<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Gateway StructType
 * @subpackage Structs
 */
class Gateway extends AbstractStructBase
{
    /**
     * The AuthenticationVerificationValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AuthenticationVerificationValue
     */
    public $AuthenticationVerificationValue;
    /**
     * The TransactionPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransactionPassword
     */
    public $TransactionPassword;
    /**
     * The ECI
     * @var string
     */
    public $ECI;
    /**
     * The MerchantID
     * @var string
     */
    public $MerchantID;
    /**
     * The ProcessorID
     * @var string
     */
    public $ProcessorID;
    /**
     * The URL
     * @var string
     */
    public $URL;
    /**
     * Constructor method for Gateway
     * @uses Gateway::setAuthenticationVerificationValue()
     * @uses Gateway::setTransactionPassword()
     * @uses Gateway::setECI()
     * @uses Gateway::setMerchantID()
     * @uses Gateway::setProcessorID()
     * @uses Gateway::setURL()
     * @param \StructType\AuthenticationVerificationValue $authenticationVerificationValue
     * @param \StructType\TransactionPassword $transactionPassword
     * @param string $eCI
     * @param string $merchantID
     * @param string $processorID
     * @param string $uRL
     */
    public function __construct(\StructType\AuthenticationVerificationValue $authenticationVerificationValue = null, \StructType\TransactionPassword $transactionPassword = null, $eCI = null, $merchantID = null, $processorID = null, $uRL = null)
    {
        $this
            ->setAuthenticationVerificationValue($authenticationVerificationValue)
            ->setTransactionPassword($transactionPassword)
            ->setECI($eCI)
            ->setMerchantID($merchantID)
            ->setProcessorID($processorID)
            ->setURL($uRL);
    }
    /**
     * Get AuthenticationVerificationValue value
     * @return \StructType\AuthenticationVerificationValue|null
     */
    public function getAuthenticationVerificationValue()
    {
        return $this->AuthenticationVerificationValue;
    }
    /**
     * Set AuthenticationVerificationValue value
     * @param \StructType\AuthenticationVerificationValue $authenticationVerificationValue
     * @return \StructType\Gateway
     */
    public function setAuthenticationVerificationValue(\StructType\AuthenticationVerificationValue $authenticationVerificationValue = null)
    {
        $this->AuthenticationVerificationValue = $authenticationVerificationValue;
        return $this;
    }
    /**
     * Get TransactionPassword value
     * @return \StructType\TransactionPassword|null
     */
    public function getTransactionPassword()
    {
        return $this->TransactionPassword;
    }
    /**
     * Set TransactionPassword value
     * @param \StructType\TransactionPassword $transactionPassword
     * @return \StructType\Gateway
     */
    public function setTransactionPassword(\StructType\TransactionPassword $transactionPassword = null)
    {
        $this->TransactionPassword = $transactionPassword;
        return $this;
    }
    /**
     * Get ECI value
     * @return string|null
     */
    public function getECI()
    {
        return $this->ECI;
    }
    /**
     * Set ECI value
     * @param string $eCI
     * @return \StructType\Gateway
     */
    public function setECI($eCI = null)
    {
        // validation for constraint: string
        if (!is_null($eCI) && !is_string($eCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCI, true), gettype($eCI)), __LINE__);
        }
        $this->ECI = $eCI;
        return $this;
    }
    /**
     * Get MerchantID value
     * @return string|null
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\Gateway
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get ProcessorID value
     * @return string|null
     */
    public function getProcessorID()
    {
        return $this->ProcessorID;
    }
    /**
     * Set ProcessorID value
     * @param string $processorID
     * @return \StructType\Gateway
     */
    public function setProcessorID($processorID = null)
    {
        // validation for constraint: string
        if (!is_null($processorID) && !is_string($processorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processorID, true), gettype($processorID)), __LINE__);
        }
        $this->ProcessorID = $processorID;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\Gateway
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Gateway
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
