<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerInvoiceDetails StructType
 * @subpackage Structs
 */
class CustomerInvoiceDetails extends AbstractStructBase
{
    /**
     * The payerKind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $payerKind;
    /**
     * The payerName
     * @var string
     */
    public $payerName;
    /**
     * The inn
     * @var string
     */
    public $inn;
    /**
     * The kpp
     * @var string
     */
    public $kpp;
    /**
     * The legalAddress
     * @var string
     */
    public $legalAddress;
    /**
     * The postalAddress
     * @var string
     */
    public $postalAddress;
    /**
     * The phone
     * @var string
     */
    public $phone;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The personInCharge
     * @var string
     */
    public $personInCharge;
    /**
     * The bankName
     * @var string
     */
    public $bankName;
    /**
     * The bik
     * @var string
     */
    public $bik;
    /**
     * The correspondentAccount
     * @var string
     */
    public $correspondentAccount;
    /**
     * The account
     * @var string
     */
    public $account;
    /**
     * Constructor method for CustomerInvoiceDetails
     * @uses CustomerInvoiceDetails::setPayerKind()
     * @uses CustomerInvoiceDetails::setPayerName()
     * @uses CustomerInvoiceDetails::setInn()
     * @uses CustomerInvoiceDetails::setKpp()
     * @uses CustomerInvoiceDetails::setLegalAddress()
     * @uses CustomerInvoiceDetails::setPostalAddress()
     * @uses CustomerInvoiceDetails::setPhone()
     * @uses CustomerInvoiceDetails::setEmail()
     * @uses CustomerInvoiceDetails::setPersonInCharge()
     * @uses CustomerInvoiceDetails::setBankName()
     * @uses CustomerInvoiceDetails::setBik()
     * @uses CustomerInvoiceDetails::setCorrespondentAccount()
     * @uses CustomerInvoiceDetails::setAccount()
     * @param string $payerKind
     * @param string $payerName
     * @param string $inn
     * @param string $kpp
     * @param string $legalAddress
     * @param string $postalAddress
     * @param string $phone
     * @param string $email
     * @param string $personInCharge
     * @param string $bankName
     * @param string $bik
     * @param string $correspondentAccount
     * @param string $account
     */
    public function __construct($payerKind = null, $payerName = null, $inn = null, $kpp = null, $legalAddress = null, $postalAddress = null, $phone = null, $email = null, $personInCharge = null, $bankName = null, $bik = null, $correspondentAccount = null, $account = null)
    {
        $this
            ->setPayerKind($payerKind)
            ->setPayerName($payerName)
            ->setInn($inn)
            ->setKpp($kpp)
            ->setLegalAddress($legalAddress)
            ->setPostalAddress($postalAddress)
            ->setPhone($phone)
            ->setEmail($email)
            ->setPersonInCharge($personInCharge)
            ->setBankName($bankName)
            ->setBik($bik)
            ->setCorrespondentAccount($correspondentAccount)
            ->setAccount($account);
    }
    /**
     * Get payerKind value
     * @return string
     */
    public function getPayerKind()
    {
        return $this->payerKind;
    }
    /**
     * Set payerKind value
     * @uses \EnumType\WebPmsPayerKind::valueIsValid()
     * @uses \EnumType\WebPmsPayerKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payerKind
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setPayerKind($payerKind = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebPmsPayerKind::valueIsValid($payerKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebPmsPayerKind', is_array($payerKind) ? implode(', ', $payerKind) : var_export($payerKind, true), implode(', ', \EnumType\WebPmsPayerKind::getValidValues())), __LINE__);
        }
        $this->payerKind = $payerKind;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get kpp value
     * @return string|null
     */
    public function getKpp()
    {
        return $this->kpp;
    }
    /**
     * Set kpp value
     * @param string $kpp
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setKpp($kpp = null)
    {
        // validation for constraint: string
        if (!is_null($kpp) && !is_string($kpp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kpp, true), gettype($kpp)), __LINE__);
        }
        $this->kpp = $kpp;
        return $this;
    }
    /**
     * Get legalAddress value
     * @return string|null
     */
    public function getLegalAddress()
    {
        return $this->legalAddress;
    }
    /**
     * Set legalAddress value
     * @param string $legalAddress
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setLegalAddress($legalAddress = null)
    {
        // validation for constraint: string
        if (!is_null($legalAddress) && !is_string($legalAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legalAddress, true), gettype($legalAddress)), __LINE__);
        }
        $this->legalAddress = $legalAddress;
        return $this;
    }
    /**
     * Get postalAddress value
     * @return string|null
     */
    public function getPostalAddress()
    {
        return $this->postalAddress;
    }
    /**
     * Set postalAddress value
     * @param string $postalAddress
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setPostalAddress($postalAddress = null)
    {
        // validation for constraint: string
        if (!is_null($postalAddress) && !is_string($postalAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalAddress, true), gettype($postalAddress)), __LINE__);
        }
        $this->postalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get personInCharge value
     * @return string|null
     */
    public function getPersonInCharge()
    {
        return $this->personInCharge;
    }
    /**
     * Set personInCharge value
     * @param string $personInCharge
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setPersonInCharge($personInCharge = null)
    {
        // validation for constraint: string
        if (!is_null($personInCharge) && !is_string($personInCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personInCharge, true), gettype($personInCharge)), __LINE__);
        }
        $this->personInCharge = $personInCharge;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get bik value
     * @return string|null
     */
    public function getBik()
    {
        return $this->bik;
    }
    /**
     * Set bik value
     * @param string $bik
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setBik($bik = null)
    {
        // validation for constraint: string
        if (!is_null($bik) && !is_string($bik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bik, true), gettype($bik)), __LINE__);
        }
        $this->bik = $bik;
        return $this;
    }
    /**
     * Get correspondentAccount value
     * @return string|null
     */
    public function getCorrespondentAccount()
    {
        return $this->correspondentAccount;
    }
    /**
     * Set correspondentAccount value
     * @param string $correspondentAccount
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setCorrespondentAccount($correspondentAccount = null)
    {
        // validation for constraint: string
        if (!is_null($correspondentAccount) && !is_string($correspondentAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correspondentAccount, true), gettype($correspondentAccount)), __LINE__);
        }
        $this->correspondentAccount = $correspondentAccount;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param string $account
     * @return \StructType\CustomerInvoiceDetails
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerInvoiceDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
