<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionableAmount StructType
 * @subpackage Structs
 */
class CommissionableAmount extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The TaxInclusiveIndicator
     * @var bool
     */
    public $TaxInclusiveIndicator;
    /**
     * Constructor method for CommissionableAmount
     * @uses CommissionableAmount::setCurrencyCode()
     * @uses CommissionableAmount::setAmount()
     * @uses CommissionableAmount::setTaxInclusiveIndicator()
     * @param string $currencyCode
     * @param float $amount
     * @param bool $taxInclusiveIndicator
     */
    public function __construct($currencyCode = null, $amount = null, $taxInclusiveIndicator = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount)
            ->setTaxInclusiveIndicator($taxInclusiveIndicator);
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CommissionableAmount
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CommissionableAmount
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxInclusiveIndicator value
     * @return bool|null
     */
    public function getTaxInclusiveIndicator()
    {
        return $this->TaxInclusiveIndicator;
    }
    /**
     * Set TaxInclusiveIndicator value
     * @param bool $taxInclusiveIndicator
     * @return \StructType\CommissionableAmount
     */
    public function setTaxInclusiveIndicator($taxInclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusiveIndicator) && !is_bool($taxInclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusiveIndicator, true), gettype($taxInclusiveIndicator)), __LINE__);
        }
        $this->TaxInclusiveIndicator = $taxInclusiveIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionableAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
