<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailStatusMessages StructType
 * @subpackage Structs
 */
class AvailStatusMessages extends AbstractStructBase
{
    /**
     * The AvailStatusMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AvailStatusMessageType[]
     */
    public $AvailStatusMessage;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for AvailStatusMessages
     * @uses AvailStatusMessages::setAvailStatusMessage()
     * @uses AvailStatusMessages::setHotelCode()
     * @uses AvailStatusMessages::setHotelName()
     * @param \StructType\AvailStatusMessageType[] $availStatusMessage
     * @param string $hotelCode
     * @param string $hotelName
     */
    public function __construct(array $availStatusMessage = array(), $hotelCode = null, $hotelName = null)
    {
        $this
            ->setAvailStatusMessage($availStatusMessage)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName);
    }
    /**
     * Get AvailStatusMessage value
     * @return \StructType\AvailStatusMessageType[]|null
     */
    public function getAvailStatusMessage()
    {
        return $this->AvailStatusMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailStatusMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailStatusMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailStatusMessageForArrayConstraintsFromSetAvailStatusMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $availStatusMessagesAvailStatusMessageItem) {
            // validation for constraint: itemType
            if (!$availStatusMessagesAvailStatusMessageItem instanceof \StructType\AvailStatusMessageType) {
                $invalidValues[] = is_object($availStatusMessagesAvailStatusMessageItem) ? get_class($availStatusMessagesAvailStatusMessageItem) : sprintf('%s(%s)', gettype($availStatusMessagesAvailStatusMessageItem), var_export($availStatusMessagesAvailStatusMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AvailStatusMessage property can only contain items of type \StructType\AvailStatusMessageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AvailStatusMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\AvailStatusMessageType[] $availStatusMessage
     * @return \StructType\AvailStatusMessages
     */
    public function setAvailStatusMessage(array $availStatusMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($availStatusMessageArrayErrorMessage = self::validateAvailStatusMessageForArrayConstraintsFromSetAvailStatusMessage($availStatusMessage))) {
            throw new \InvalidArgumentException($availStatusMessageArrayErrorMessage, __LINE__);
        }
        $this->AvailStatusMessage = $availStatusMessage;
        return $this;
    }
    /**
     * Add item to AvailStatusMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\AvailStatusMessageType $item
     * @return \StructType\AvailStatusMessages
     */
    public function addToAvailStatusMessage(\StructType\AvailStatusMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AvailStatusMessageType) {
            throw new \InvalidArgumentException(sprintf('The AvailStatusMessage property can only contain items of type \StructType\AvailStatusMessageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AvailStatusMessage[] = $item;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\AvailStatusMessages
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\AvailStatusMessages
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailStatusMessages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
