<?php

namespace EnumType;

/**
 * This class stands for WebPmsPayerKind EnumType
 * @subpackage Enumerations
 */
class WebPmsPayerKind
{
    /**
     * Constant for value 'legalEntity'
     * @return string 'legalEntity'
     */
    const VALUE_LEGAL_ENTITY = 'legalEntity';
    /**
     * Constant for value 'individual'
     * @return string 'individual'
     */
    const VALUE_INDIVIDUAL = 'individual';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LEGAL_ENTITY
     * @uses self::VALUE_INDIVIDUAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LEGAL_ENTITY,
            self::VALUE_INDIVIDUAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
