<?php

namespace EnumType;

/**
 * This class stands for TransferDirectionEnum EnumType
 * @subpackage Enumerations
 */
class TransferDirectionEnum
{
    /**
     * Constant for value 'Tohotel'
     * @return string 'Tohotel'
     */
    const VALUE_TOHOTEL = 'Tohotel';
    /**
     * Constant for value 'Fromhotel'
     * @return string 'Fromhotel'
     */
    const VALUE_FROMHOTEL = 'Fromhotel';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TOHOTEL
     * @uses self::VALUE_FROMHOTEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TOHOTEL,
            self::VALUE_FROMHOTEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
