<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString ArrayType
 * @subpackage Arrays
 */
class ArrayOfString extends AbstractStructArrayBase
{
    /**
     * The AdditionalPersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AdditionalPersonName;
    /**
     * Constructor method for ArrayOfString
     * @uses ArrayOfString::setAdditionalPersonName()
     * @param string[] $additionalPersonName
     */
    public function __construct(array $additionalPersonName = array())
    {
        $this
            ->setAdditionalPersonName($additionalPersonName);
    }
    /**
     * Get AdditionalPersonName value
     * @return string[]|null
     */
    public function getAdditionalPersonName()
    {
        return $this->AdditionalPersonName;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalPersonName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalPersonName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalPersonNameForArrayConstraintsFromSetAdditionalPersonName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStringAdditionalPersonNameItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfStringAdditionalPersonNameItem)) {
                $invalidValues[] = is_object($arrayOfStringAdditionalPersonNameItem) ? get_class($arrayOfStringAdditionalPersonNameItem) : sprintf('%s(%s)', gettype($arrayOfStringAdditionalPersonNameItem), var_export($arrayOfStringAdditionalPersonNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalPersonName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalPersonName value
     * @throws \InvalidArgumentException
     * @param string[] $additionalPersonName
     * @return \ArrayType\ArrayOfString
     */
    public function setAdditionalPersonName(array $additionalPersonName = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalPersonNameArrayErrorMessage = self::validateAdditionalPersonNameForArrayConstraintsFromSetAdditionalPersonName($additionalPersonName))) {
            throw new \InvalidArgumentException($additionalPersonNameArrayErrorMessage, __LINE__);
        }
        $this->AdditionalPersonName = $additionalPersonName;
        return $this;
    }
    /**
     * Add item to AdditionalPersonName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString
     */
    public function addToAdditionalPersonName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AdditionalPersonName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalPersonName[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdditionalPersonName
     */
    public function getAttributeName()
    {
        return 'AdditionalPersonName';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
