<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserID StructType
 * @subpackage Structs
 */
class UserID extends UniqueID_Type
{
    /**
     * The PinNumber
     * @var string
     */
    public $PinNumber;
    /**
     * Constructor method for UserID
     * @uses UserID::setPinNumber()
     * @param string $pinNumber
     */
    public function __construct($pinNumber = null)
    {
        $this
            ->setPinNumber($pinNumber);
    }
    /**
     * Get PinNumber value
     * @return string|null
     */
    public function getPinNumber()
    {
        return $this->PinNumber;
    }
    /**
     * Set PinNumber value
     * @param string $pinNumber
     * @return \StructType\UserID
     */
    public function setPinNumber($pinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pinNumber) && !is_string($pinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pinNumber, true), gettype($pinNumber)), __LINE__);
        }
        $this->PinNumber = $pinNumber;
        return $this;
    }
}
