<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionPassword StructType
 * @subpackage Structs
 */
class TransactionPassword extends AbstractStructBase
{
    /**
     * The PlainText
     * Meta information extracted from the WSDL
     * - choice: PlainText | Secure
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlainText;
    /**
     * The Secure
     * Meta information extracted from the WSDL
     * - choice: PlainText | Secure
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionTokenType
     */
    public $Secure;
    /**
     * Constructor method for TransactionPassword
     * @uses TransactionPassword::setPlainText()
     * @uses TransactionPassword::setSecure()
     * @param string $plainText
     * @param \StructType\EncryptionTokenType $secure
     */
    public function __construct($plainText = null, \StructType\EncryptionTokenType $secure = null)
    {
        $this
            ->setPlainText($plainText)
            ->setSecure($secure);
    }
    /**
     * Get PlainText value
     * @return string|null
     */
    public function getPlainText()
    {
        return isset($this->PlainText) ? $this->PlainText : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPlainText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlainText method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePlainTextForChoiceConstraintsFromSetPlainText($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Secure',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PlainText can\'t be set as the property %s is already set. Only one property must be set among these properties: PlainText, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PlainText value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $plainText
     * @return \StructType\TransactionPassword
     */
    public function setPlainText($plainText = null)
    {
        // validation for constraint: string
        if (!is_null($plainText) && !is_string($plainText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plainText, true), gettype($plainText)), __LINE__);
        }
        // validation for constraint: choice(PlainText, Secure)
        if ('' !== ($plainTextChoiceErrorMessage = self::validatePlainTextForChoiceConstraintsFromSetPlainText($plainText))) {
            throw new \InvalidArgumentException($plainTextChoiceErrorMessage, __LINE__);
        }
        if (is_null($plainText) || (is_array($plainText) && empty($plainText))) {
            unset($this->PlainText);
        } else {
            $this->PlainText = $plainText;
        }
        return $this;
    }
    /**
     * Get Secure value
     * @return \StructType\EncryptionTokenType|null
     */
    public function getSecure()
    {
        return isset($this->Secure) ? $this->Secure : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSecure method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSecure method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSecureForChoiceConstraintsFromSetSecure($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PlainText',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Secure can\'t be set as the property %s is already set. Only one property must be set among these properties: Secure, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Secure value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EncryptionTokenType $secure
     * @return \StructType\TransactionPassword
     */
    public function setSecure(\StructType\EncryptionTokenType $secure = null)
    {
        // validation for constraint: choice(PlainText, Secure)
        if ('' !== ($secureChoiceErrorMessage = self::validateSecureForChoiceConstraintsFromSetSecure($secure))) {
            throw new \InvalidArgumentException($secureChoiceErrorMessage, __LINE__);
        }
        if (is_null($secure) || (is_array($secure) && empty($secure))) {
            unset($this->Secure);
        } else {
            $this->Secure = $secure;
        }
        return $this;
    }
}
