<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellableProduct StructType
 * @subpackage Structs
 */
class SellableProduct extends AbstractStructBase
{
    /**
     * The GuestRoom
     * Meta information extracted from the WSDL
     * - choice: GuestRoom | InventoryBlock | GuestRoom | InventoryBlock
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GuestRoomType
     */
    public $GuestRoom;
    /**
     * The InventoryBlock
     * Meta information extracted from the WSDL
     * - choice: GuestRoom | InventoryBlock | GuestRoom | InventoryBlock
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InventoryBlock
     */
    public $InventoryBlock;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $Description;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The InvCode
     * @var string
     */
    public $InvCode;
    /**
     * The IsRoom
     * @var bool
     */
    public $IsRoom;
    /**
     * The InvNotifType
     * @var string
     */
    public $InvNotifType;
    /**
     * The InvStatusType
     * @var string
     */
    public $InvStatusType;
    /**
     * Constructor method for SellableProduct
     * @uses SellableProduct::setGuestRoom()
     * @uses SellableProduct::setInventoryBlock()
     * @uses SellableProduct::setDescription()
     * @uses SellableProduct::setUniqueID()
     * @uses SellableProduct::setRPH()
     * @uses SellableProduct::setInvCode()
     * @uses SellableProduct::setIsRoom()
     * @uses SellableProduct::setInvNotifType()
     * @uses SellableProduct::setInvStatusType()
     * @param \StructType\GuestRoomType $guestRoom
     * @param \StructType\InventoryBlock $inventoryBlock
     * @param \StructType\ParagraphType $description
     * @param \StructType\UniqueID_Type $uniqueID
     * @param string $rPH
     * @param string $invCode
     * @param bool $isRoom
     * @param string $invNotifType
     * @param string $invStatusType
     */
    public function __construct(\StructType\GuestRoomType $guestRoom = null, \StructType\InventoryBlock $inventoryBlock = null, \StructType\ParagraphType $description = null, \StructType\UniqueID_Type $uniqueID = null, $rPH = null, $invCode = null, $isRoom = null, $invNotifType = null, $invStatusType = null)
    {
        $this
            ->setGuestRoom($guestRoom)
            ->setInventoryBlock($inventoryBlock)
            ->setDescription($description)
            ->setUniqueID($uniqueID)
            ->setRPH($rPH)
            ->setInvCode($invCode)
            ->setIsRoom($isRoom)
            ->setInvNotifType($invNotifType)
            ->setInvStatusType($invStatusType);
    }
    /**
     * Get GuestRoom value
     * @return \StructType\GuestRoomType|null
     */
    public function getGuestRoom()
    {
        return isset($this->GuestRoom) ? $this->GuestRoom : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGuestRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestRoom method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGuestRoomForChoiceConstraintsFromSetGuestRoom($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'InventoryBlock',
            'InventoryBlock',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GuestRoom can\'t be set as the property %s is already set. Only one property must be set among these properties: GuestRoom, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GuestRoom value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GuestRoomType $guestRoom
     * @return \StructType\SellableProduct
     */
    public function setGuestRoom(\StructType\GuestRoomType $guestRoom = null)
    {
        // validation for constraint: choice(GuestRoom, InventoryBlock, GuestRoom, InventoryBlock)
        if ('' !== ($guestRoomChoiceErrorMessage = self::validateGuestRoomForChoiceConstraintsFromSetGuestRoom($guestRoom))) {
            throw new \InvalidArgumentException($guestRoomChoiceErrorMessage, __LINE__);
        }
        if (is_null($guestRoom) || (is_array($guestRoom) && empty($guestRoom))) {
            unset($this->GuestRoom);
        } else {
            $this->GuestRoom = $guestRoom;
        }
        return $this;
    }
    /**
     * Get InventoryBlock value
     * @return \StructType\InventoryBlock|null
     */
    public function getInventoryBlock()
    {
        return isset($this->InventoryBlock) ? $this->InventoryBlock : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInventoryBlock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryBlock method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInventoryBlockForChoiceConstraintsFromSetInventoryBlock($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GuestRoom',
            'GuestRoom',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property InventoryBlock can\'t be set as the property %s is already set. Only one property must be set among these properties: InventoryBlock, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set InventoryBlock value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryBlock $inventoryBlock
     * @return \StructType\SellableProduct
     */
    public function setInventoryBlock(\StructType\InventoryBlock $inventoryBlock = null)
    {
        // validation for constraint: choice(GuestRoom, InventoryBlock, GuestRoom, InventoryBlock)
        if ('' !== ($inventoryBlockChoiceErrorMessage = self::validateInventoryBlockForChoiceConstraintsFromSetInventoryBlock($inventoryBlock))) {
            throw new \InvalidArgumentException($inventoryBlockChoiceErrorMessage, __LINE__);
        }
        if (is_null($inventoryBlock) || (is_array($inventoryBlock) && empty($inventoryBlock))) {
            unset($this->InventoryBlock);
        } else {
            $this->InventoryBlock = $inventoryBlock;
        }
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\ParagraphType $description
     * @return \StructType\SellableProduct
     */
    public function setDescription(\StructType\ParagraphType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\SellableProduct
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\SellableProduct
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get InvCode value
     * @return string|null
     */
    public function getInvCode()
    {
        return $this->InvCode;
    }
    /**
     * Set InvCode value
     * @param string $invCode
     * @return \StructType\SellableProduct
     */
    public function setInvCode($invCode = null)
    {
        // validation for constraint: string
        if (!is_null($invCode) && !is_string($invCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invCode, true), gettype($invCode)), __LINE__);
        }
        $this->InvCode = $invCode;
        return $this;
    }
    /**
     * Get IsRoom value
     * @return bool|null
     */
    public function getIsRoom()
    {
        return $this->IsRoom;
    }
    /**
     * Set IsRoom value
     * @param bool $isRoom
     * @return \StructType\SellableProduct
     */
    public function setIsRoom($isRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoom) && !is_bool($isRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoom, true), gettype($isRoom)), __LINE__);
        }
        $this->IsRoom = $isRoom;
        return $this;
    }
    /**
     * Get InvNotifType value
     * @return string|null
     */
    public function getInvNotifType()
    {
        return $this->InvNotifType;
    }
    /**
     * Set InvNotifType value
     * @param string $invNotifType
     * @return \StructType\SellableProduct
     */
    public function setInvNotifType($invNotifType = null)
    {
        // validation for constraint: string
        if (!is_null($invNotifType) && !is_string($invNotifType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invNotifType, true), gettype($invNotifType)), __LINE__);
        }
        $this->InvNotifType = $invNotifType;
        return $this;
    }
    /**
     * Get InvStatusType value
     * @return string|null
     */
    public function getInvStatusType()
    {
        return $this->InvStatusType;
    }
    /**
     * Set InvStatusType value
     * @param string $invStatusType
     * @return \StructType\SellableProduct
     */
    public function setInvStatusType($invStatusType = null)
    {
        // validation for constraint: string
        if (!is_null($invStatusType) && !is_string($invStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invStatusType, true), gettype($invStatusType)), __LINE__);
        }
        $this->InvStatusType = $invStatusType;
        return $this;
    }
}
