<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeType StructType
 * @subpackage Structs
 */
class RoomTypeType extends AbstractStructBase
{
    /**
     * The RoomDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $RoomDescription;
    /**
     * The Occupancy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Occupancy[]
     */
    public $Occupancy;
    /**
     * The Amenities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomAmenityPrefType
     */
    public $Amenities;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The RoomCategory
     * @var string
     */
    public $RoomCategory;
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for RoomTypeType
     * @uses RoomTypeType::setRoomDescription()
     * @uses RoomTypeType::setOccupancy()
     * @uses RoomTypeType::setAmenities()
     * @uses RoomTypeType::setTPA_Extensions()
     * @uses RoomTypeType::setRoomType()
     * @uses RoomTypeType::setRoomTypeCode()
     * @uses RoomTypeType::setRoomCategory()
     * @uses RoomTypeType::setInvBlockCode()
     * @uses RoomTypeType::setQuantity()
     * @param \StructType\ParagraphType $roomDescription
     * @param \StructType\Occupancy[] $occupancy
     * @param \ArrayType\ArrayOfRoomAmenityPrefType $amenities
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $roomType
     * @param string $roomTypeCode
     * @param string $roomCategory
     * @param string $invBlockCode
     * @param int $quantity
     */
    public function __construct(\StructType\ParagraphType $roomDescription = null, array $occupancy = array(), \ArrayType\ArrayOfRoomAmenityPrefType $amenities = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $roomType = null, $roomTypeCode = null, $roomCategory = null, $invBlockCode = null, $quantity = null)
    {
        $this
            ->setRoomDescription($roomDescription)
            ->setOccupancy($occupancy)
            ->setAmenities($amenities)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRoomType($roomType)
            ->setRoomTypeCode($roomTypeCode)
            ->setRoomCategory($roomCategory)
            ->setInvBlockCode($invBlockCode)
            ->setQuantity($quantity);
    }
    /**
     * Get RoomDescription value
     * @return \StructType\ParagraphType|null
     */
    public function getRoomDescription()
    {
        return $this->RoomDescription;
    }
    /**
     * Set RoomDescription value
     * @param \StructType\ParagraphType $roomDescription
     * @return \StructType\RoomTypeType
     */
    public function setRoomDescription(\StructType\ParagraphType $roomDescription = null)
    {
        $this->RoomDescription = $roomDescription;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return \StructType\Occupancy[]|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * This method is responsible for validating the values passed to the setOccupancy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOccupancy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOccupancyForArrayConstraintsFromSetOccupancy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomTypeTypeOccupancyItem) {
            // validation for constraint: itemType
            if (!$roomTypeTypeOccupancyItem instanceof \StructType\Occupancy) {
                $invalidValues[] = is_object($roomTypeTypeOccupancyItem) ? get_class($roomTypeTypeOccupancyItem) : sprintf('%s(%s)', gettype($roomTypeTypeOccupancyItem), var_export($roomTypeTypeOccupancyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy[] $occupancy
     * @return \StructType\RoomTypeType
     */
    public function setOccupancy(array $occupancy = array())
    {
        // validation for constraint: array
        if ('' !== ($occupancyArrayErrorMessage = self::validateOccupancyForArrayConstraintsFromSetOccupancy($occupancy))) {
            throw new \InvalidArgumentException($occupancyArrayErrorMessage, __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Add item to Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy $item
     * @return \StructType\RoomTypeType
     */
    public function addToOccupancy(\StructType\Occupancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Occupancy) {
            throw new \InvalidArgumentException(sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Occupancy[] = $item;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \ArrayType\ArrayOfRoomAmenityPrefType|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \ArrayType\ArrayOfRoomAmenityPrefType $amenities
     * @return \StructType\RoomTypeType
     */
    public function setAmenities(\ArrayType\ArrayOfRoomAmenityPrefType $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\RoomTypeType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\RoomTypeType
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomTypeType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return string|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * Set RoomCategory value
     * @param string $roomCategory
     * @return \StructType\RoomTypeType
     */
    public function setRoomCategory($roomCategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategory) && !is_string($roomCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCategory, true), gettype($roomCategory)), __LINE__);
        }
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\RoomTypeType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\RoomTypeType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
}
