<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffSell StructType
 * @subpackage Structs
 */
class OffSell extends AbstractStructBase
{
    /**
     * The OffSellValueType
     * @var string
     */
    public $OffSellValueType;
    /**
     * The OffSellValue
     * @var float
     */
    public $OffSellValue;
    /**
     * Constructor method for OffSell
     * @uses OffSell::setOffSellValueType()
     * @uses OffSell::setOffSellValue()
     * @param string $offSellValueType
     * @param float $offSellValue
     */
    public function __construct($offSellValueType = null, $offSellValue = null)
    {
        $this
            ->setOffSellValueType($offSellValueType)
            ->setOffSellValue($offSellValue);
    }
    /**
     * Get OffSellValueType value
     * @return string|null
     */
    public function getOffSellValueType()
    {
        return $this->OffSellValueType;
    }
    /**
     * Set OffSellValueType value
     * @param string $offSellValueType
     * @return \StructType\OffSell
     */
    public function setOffSellValueType($offSellValueType = null)
    {
        // validation for constraint: string
        if (!is_null($offSellValueType) && !is_string($offSellValueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offSellValueType, true), gettype($offSellValueType)), __LINE__);
        }
        $this->OffSellValueType = $offSellValueType;
        return $this;
    }
    /**
     * Get OffSellValue value
     * @return float|null
     */
    public function getOffSellValue()
    {
        return $this->OffSellValue;
    }
    /**
     * Set OffSellValue value
     * @param float $offSellValue
     * @return \StructType\OffSell
     */
    public function setOffSellValue($offSellValue = null)
    {
        // validation for constraint: float
        if (!is_null($offSellValue) && !(is_float($offSellValue) || is_numeric($offSellValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($offSellValue, true), gettype($offSellValue)), __LINE__);
        }
        $this->OffSellValue = $offSellValue;
        return $this;
    }
}
