<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LengthsOfStayCandidates StructType
 * @subpackage Structs
 */
class LengthsOfStayCandidates extends AbstractStructBase
{
    /**
     * The LengthOfStayCandidate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LengthOfStayCandidate[]
     */
    public $LengthOfStayCandidate;
    /**
     * The SendAllLengthsOfStay
     * @var bool
     */
    public $SendAllLengthsOfStay;
    /**
     * The FixedPatternLength
     * @var int
     */
    public $FixedPatternLength;
    /**
     * Constructor method for LengthsOfStayCandidates
     * @uses LengthsOfStayCandidates::setLengthOfStayCandidate()
     * @uses LengthsOfStayCandidates::setSendAllLengthsOfStay()
     * @uses LengthsOfStayCandidates::setFixedPatternLength()
     * @param \StructType\LengthOfStayCandidate[] $lengthOfStayCandidate
     * @param bool $sendAllLengthsOfStay
     * @param int $fixedPatternLength
     */
    public function __construct(array $lengthOfStayCandidate = array(), $sendAllLengthsOfStay = null, $fixedPatternLength = null)
    {
        $this
            ->setLengthOfStayCandidate($lengthOfStayCandidate)
            ->setSendAllLengthsOfStay($sendAllLengthsOfStay)
            ->setFixedPatternLength($fixedPatternLength);
    }
    /**
     * Get LengthOfStayCandidate value
     * @return \StructType\LengthOfStayCandidate[]|null
     */
    public function getLengthOfStayCandidate()
    {
        return $this->LengthOfStayCandidate;
    }
    /**
     * This method is responsible for validating the values passed to the setLengthOfStayCandidate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLengthOfStayCandidate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLengthOfStayCandidateForArrayConstraintsFromSetLengthOfStayCandidate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lengthsOfStayCandidatesLengthOfStayCandidateItem) {
            // validation for constraint: itemType
            if (!$lengthsOfStayCandidatesLengthOfStayCandidateItem instanceof \StructType\LengthOfStayCandidate) {
                $invalidValues[] = is_object($lengthsOfStayCandidatesLengthOfStayCandidateItem) ? get_class($lengthsOfStayCandidatesLengthOfStayCandidateItem) : sprintf('%s(%s)', gettype($lengthsOfStayCandidatesLengthOfStayCandidateItem), var_export($lengthsOfStayCandidatesLengthOfStayCandidateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LengthOfStayCandidate property can only contain items of type \StructType\LengthOfStayCandidate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LengthOfStayCandidate value
     * @throws \InvalidArgumentException
     * @param \StructType\LengthOfStayCandidate[] $lengthOfStayCandidate
     * @return \StructType\LengthsOfStayCandidates
     */
    public function setLengthOfStayCandidate(array $lengthOfStayCandidate = array())
    {
        // validation for constraint: array
        if ('' !== ($lengthOfStayCandidateArrayErrorMessage = self::validateLengthOfStayCandidateForArrayConstraintsFromSetLengthOfStayCandidate($lengthOfStayCandidate))) {
            throw new \InvalidArgumentException($lengthOfStayCandidateArrayErrorMessage, __LINE__);
        }
        $this->LengthOfStayCandidate = $lengthOfStayCandidate;
        return $this;
    }
    /**
     * Add item to LengthOfStayCandidate value
     * @throws \InvalidArgumentException
     * @param \StructType\LengthOfStayCandidate $item
     * @return \StructType\LengthsOfStayCandidates
     */
    public function addToLengthOfStayCandidate(\StructType\LengthOfStayCandidate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LengthOfStayCandidate) {
            throw new \InvalidArgumentException(sprintf('The LengthOfStayCandidate property can only contain items of type \StructType\LengthOfStayCandidate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LengthOfStayCandidate[] = $item;
        return $this;
    }
    /**
     * Get SendAllLengthsOfStay value
     * @return bool|null
     */
    public function getSendAllLengthsOfStay()
    {
        return $this->SendAllLengthsOfStay;
    }
    /**
     * Set SendAllLengthsOfStay value
     * @param bool $sendAllLengthsOfStay
     * @return \StructType\LengthsOfStayCandidates
     */
    public function setSendAllLengthsOfStay($sendAllLengthsOfStay = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendAllLengthsOfStay) && !is_bool($sendAllLengthsOfStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendAllLengthsOfStay, true), gettype($sendAllLengthsOfStay)), __LINE__);
        }
        $this->SendAllLengthsOfStay = $sendAllLengthsOfStay;
        return $this;
    }
    /**
     * Get FixedPatternLength value
     * @return int|null
     */
    public function getFixedPatternLength()
    {
        return $this->FixedPatternLength;
    }
    /**
     * Set FixedPatternLength value
     * @param int $fixedPatternLength
     * @return \StructType\LengthsOfStayCandidates
     */
    public function setFixedPatternLength($fixedPatternLength = null)
    {
        // validation for constraint: int
        if (!is_null($fixedPatternLength) && !(is_int($fixedPatternLength) || ctype_digit($fixedPatternLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fixedPatternLength, true), gettype($fixedPatternLength)), __LINE__);
        }
        $this->FixedPatternLength = $fixedPatternLength;
        return $this;
    }
}
