<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LengthOfStayCandidate StructType
 * @subpackage Structs
 */
class LengthOfStayCandidate extends AbstractStructBase
{
    /**
     * The MinMaxMessageType
     * @var string
     */
    public $MinMaxMessageType;
    /**
     * Constructor method for LengthOfStayCandidate
     * @uses LengthOfStayCandidate::setMinMaxMessageType()
     * @param string $minMaxMessageType
     */
    public function __construct($minMaxMessageType = null)
    {
        $this
            ->setMinMaxMessageType($minMaxMessageType);
    }
    /**
     * Get MinMaxMessageType value
     * @return string|null
     */
    public function getMinMaxMessageType()
    {
        return $this->MinMaxMessageType;
    }
    /**
     * Set MinMaxMessageType value
     * @param string $minMaxMessageType
     * @return \StructType\LengthOfStayCandidate
     */
    public function setMinMaxMessageType($minMaxMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($minMaxMessageType) && !is_string($minMaxMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minMaxMessageType, true), gettype($minMaxMessageType)), __LINE__);
        }
        $this->MinMaxMessageType = $minMaxMessageType;
        return $this;
    }
}
