<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDescriptiveContent StructType
 * @subpackage Structs
 */
class HotelDescriptiveContent extends HotelDescriptiveContentType
{
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for HotelDescriptiveContent
     * @uses HotelDescriptiveContent::setHotelCode()
     * @uses HotelDescriptiveContent::setHotelName()
     * @param string $hotelCode
     * @param string $hotelName
     */
    public function __construct($hotelCode = null, $hotelName = null)
    {
        $this
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName);
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelDescriptiveContent
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelDescriptiveContent
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
}
