<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelAvailRequest StructType
 * @subpackage Structs
 */
class HotelAvailRequest extends AbstractStructBase
{
    /**
     * The DateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateRange
     */
    public $DateRange;
    /**
     * The DestinationSystemsCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode
     */
    public $DestinationSystemsCode;
    /**
     * The RatePlanCandidates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate
     */
    public $RatePlanCandidates;
    /**
     * The RoomTypeCandidates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOTA_HotelAvailGetRQHotelAvailRequestRoomTypeCandidate
     */
    public $RoomTypeCandidates;
    /**
     * The Offers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Offers
     */
    public $Offers;
    /**
     * The RestrictionStatusCandidates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RestrictionStatusCandidates
     */
    public $RestrictionStatusCandidates;
    /**
     * The LengthsOfStayCandidates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LengthsOfStayCandidates
     */
    public $LengthsOfStayCandidates;
    /**
     * The BestAvailableRateCandidate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BestAvailableRateCandidate
     */
    public $BestAvailableRateCandidate;
    /**
     * The HurdleRateCandidate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HurdleRateCandidate
     */
    public $HurdleRateCandidate;
    /**
     * The DeltaCandidate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeltaCandidate
     */
    public $DeltaCandidate;
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The RebatePrograms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RebatePrograms
     */
    public $RebatePrograms;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The SendBookingLimit
     * @var bool
     */
    public $SendBookingLimit;
    /**
     * The BookingLimitMessageType
     * @var string
     */
    public $BookingLimitMessageType;
    /**
     * Constructor method for HotelAvailRequest
     * @uses HotelAvailRequest::setDateRange()
     * @uses HotelAvailRequest::setDestinationSystemsCode()
     * @uses HotelAvailRequest::setRatePlanCandidates()
     * @uses HotelAvailRequest::setRoomTypeCandidates()
     * @uses HotelAvailRequest::setOffers()
     * @uses HotelAvailRequest::setRestrictionStatusCandidates()
     * @uses HotelAvailRequest::setLengthsOfStayCandidates()
     * @uses HotelAvailRequest::setBestAvailableRateCandidate()
     * @uses HotelAvailRequest::setHurdleRateCandidate()
     * @uses HotelAvailRequest::setDeltaCandidate()
     * @uses HotelAvailRequest::setHotelRef()
     * @uses HotelAvailRequest::setRebatePrograms()
     * @uses HotelAvailRequest::setTPA_Extensions()
     * @uses HotelAvailRequest::setSendBookingLimit()
     * @uses HotelAvailRequest::setBookingLimitMessageType()
     * @param \StructType\DateRange $dateRange
     * @param \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode $destinationSystemsCode
     * @param \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates
     * @param \ArrayType\ArrayOfOTA_HotelAvailGetRQHotelAvailRequestRoomTypeCandidate $roomTypeCandidates
     * @param \StructType\Offers $offers
     * @param \StructType\RestrictionStatusCandidates $restrictionStatusCandidates
     * @param \StructType\LengthsOfStayCandidates $lengthsOfStayCandidates
     * @param \StructType\BestAvailableRateCandidate $bestAvailableRateCandidate
     * @param \StructType\HurdleRateCandidate $hurdleRateCandidate
     * @param \StructType\DeltaCandidate $deltaCandidate
     * @param \StructType\HotelRef $hotelRef
     * @param \StructType\RebatePrograms $rebatePrograms
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param bool $sendBookingLimit
     * @param string $bookingLimitMessageType
     */
    public function __construct(\StructType\DateRange $dateRange = null, \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode $destinationSystemsCode = null, \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates = null, \ArrayType\ArrayOfOTA_HotelAvailGetRQHotelAvailRequestRoomTypeCandidate $roomTypeCandidates = null, \StructType\Offers $offers = null, \StructType\RestrictionStatusCandidates $restrictionStatusCandidates = null, \StructType\LengthsOfStayCandidates $lengthsOfStayCandidates = null, \StructType\BestAvailableRateCandidate $bestAvailableRateCandidate = null, \StructType\HurdleRateCandidate $hurdleRateCandidate = null, \StructType\DeltaCandidate $deltaCandidate = null, \StructType\HotelRef $hotelRef = null, \StructType\RebatePrograms $rebatePrograms = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $sendBookingLimit = null, $bookingLimitMessageType = null)
    {
        $this
            ->setDateRange($dateRange)
            ->setDestinationSystemsCode($destinationSystemsCode)
            ->setRatePlanCandidates($ratePlanCandidates)
            ->setRoomTypeCandidates($roomTypeCandidates)
            ->setOffers($offers)
            ->setRestrictionStatusCandidates($restrictionStatusCandidates)
            ->setLengthsOfStayCandidates($lengthsOfStayCandidates)
            ->setBestAvailableRateCandidate($bestAvailableRateCandidate)
            ->setHurdleRateCandidate($hurdleRateCandidate)
            ->setDeltaCandidate($deltaCandidate)
            ->setHotelRef($hotelRef)
            ->setRebatePrograms($rebatePrograms)
            ->setTPA_Extensions($tPA_Extensions)
            ->setSendBookingLimit($sendBookingLimit)
            ->setBookingLimitMessageType($bookingLimitMessageType);
    }
    /**
     * Get DateRange value
     * @return \StructType\DateRange|null
     */
    public function getDateRange()
    {
        return $this->DateRange;
    }
    /**
     * Set DateRange value
     * @param \StructType\DateRange $dateRange
     * @return \StructType\HotelAvailRequest
     */
    public function setDateRange(\StructType\DateRange $dateRange = null)
    {
        $this->DateRange = $dateRange;
        return $this;
    }
    /**
     * Get DestinationSystemsCode value
     * @return \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode|null
     */
    public function getDestinationSystemsCode()
    {
        return $this->DestinationSystemsCode;
    }
    /**
     * Set DestinationSystemsCode value
     * @param \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode $destinationSystemsCode
     * @return \StructType\HotelAvailRequest
     */
    public function setDestinationSystemsCode(\ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode $destinationSystemsCode = null)
    {
        $this->DestinationSystemsCode = $destinationSystemsCode;
        return $this;
    }
    /**
     * Get RatePlanCandidates value
     * @return \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate|null
     */
    public function getRatePlanCandidates()
    {
        return $this->RatePlanCandidates;
    }
    /**
     * Set RatePlanCandidates value
     * @param \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates
     * @return \StructType\HotelAvailRequest
     */
    public function setRatePlanCandidates(\ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates = null)
    {
        $this->RatePlanCandidates = $ratePlanCandidates;
        return $this;
    }
    /**
     * Get RoomTypeCandidates value
     * @return \ArrayType\ArrayOfOTA_HotelAvailGetRQHotelAvailRequestRoomTypeCandidate|null
     */
    public function getRoomTypeCandidates()
    {
        return $this->RoomTypeCandidates;
    }
    /**
     * Set RoomTypeCandidates value
     * @param \ArrayType\ArrayOfOTA_HotelAvailGetRQHotelAvailRequestRoomTypeCandidate $roomTypeCandidates
     * @return \StructType\HotelAvailRequest
     */
    public function setRoomTypeCandidates(\ArrayType\ArrayOfOTA_HotelAvailGetRQHotelAvailRequestRoomTypeCandidate $roomTypeCandidates = null)
    {
        $this->RoomTypeCandidates = $roomTypeCandidates;
        return $this;
    }
    /**
     * Get Offers value
     * @return \StructType\Offers|null
     */
    public function getOffers()
    {
        return $this->Offers;
    }
    /**
     * Set Offers value
     * @param \StructType\Offers $offers
     * @return \StructType\HotelAvailRequest
     */
    public function setOffers(\StructType\Offers $offers = null)
    {
        $this->Offers = $offers;
        return $this;
    }
    /**
     * Get RestrictionStatusCandidates value
     * @return \StructType\RestrictionStatusCandidates|null
     */
    public function getRestrictionStatusCandidates()
    {
        return $this->RestrictionStatusCandidates;
    }
    /**
     * Set RestrictionStatusCandidates value
     * @param \StructType\RestrictionStatusCandidates $restrictionStatusCandidates
     * @return \StructType\HotelAvailRequest
     */
    public function setRestrictionStatusCandidates(\StructType\RestrictionStatusCandidates $restrictionStatusCandidates = null)
    {
        $this->RestrictionStatusCandidates = $restrictionStatusCandidates;
        return $this;
    }
    /**
     * Get LengthsOfStayCandidates value
     * @return \StructType\LengthsOfStayCandidates|null
     */
    public function getLengthsOfStayCandidates()
    {
        return $this->LengthsOfStayCandidates;
    }
    /**
     * Set LengthsOfStayCandidates value
     * @param \StructType\LengthsOfStayCandidates $lengthsOfStayCandidates
     * @return \StructType\HotelAvailRequest
     */
    public function setLengthsOfStayCandidates(\StructType\LengthsOfStayCandidates $lengthsOfStayCandidates = null)
    {
        $this->LengthsOfStayCandidates = $lengthsOfStayCandidates;
        return $this;
    }
    /**
     * Get BestAvailableRateCandidate value
     * @return \StructType\BestAvailableRateCandidate|null
     */
    public function getBestAvailableRateCandidate()
    {
        return $this->BestAvailableRateCandidate;
    }
    /**
     * Set BestAvailableRateCandidate value
     * @param \StructType\BestAvailableRateCandidate $bestAvailableRateCandidate
     * @return \StructType\HotelAvailRequest
     */
    public function setBestAvailableRateCandidate(\StructType\BestAvailableRateCandidate $bestAvailableRateCandidate = null)
    {
        $this->BestAvailableRateCandidate = $bestAvailableRateCandidate;
        return $this;
    }
    /**
     * Get HurdleRateCandidate value
     * @return \StructType\HurdleRateCandidate|null
     */
    public function getHurdleRateCandidate()
    {
        return $this->HurdleRateCandidate;
    }
    /**
     * Set HurdleRateCandidate value
     * @param \StructType\HurdleRateCandidate $hurdleRateCandidate
     * @return \StructType\HotelAvailRequest
     */
    public function setHurdleRateCandidate(\StructType\HurdleRateCandidate $hurdleRateCandidate = null)
    {
        $this->HurdleRateCandidate = $hurdleRateCandidate;
        return $this;
    }
    /**
     * Get DeltaCandidate value
     * @return \StructType\DeltaCandidate|null
     */
    public function getDeltaCandidate()
    {
        return $this->DeltaCandidate;
    }
    /**
     * Set DeltaCandidate value
     * @param \StructType\DeltaCandidate $deltaCandidate
     * @return \StructType\HotelAvailRequest
     */
    public function setDeltaCandidate(\StructType\DeltaCandidate $deltaCandidate = null)
    {
        $this->DeltaCandidate = $deltaCandidate;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\HotelAvailRequest
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get RebatePrograms value
     * @return \StructType\RebatePrograms|null
     */
    public function getRebatePrograms()
    {
        return $this->RebatePrograms;
    }
    /**
     * Set RebatePrograms value
     * @param \StructType\RebatePrograms $rebatePrograms
     * @return \StructType\HotelAvailRequest
     */
    public function setRebatePrograms(\StructType\RebatePrograms $rebatePrograms = null)
    {
        $this->RebatePrograms = $rebatePrograms;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\HotelAvailRequest
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get SendBookingLimit value
     * @return bool|null
     */
    public function getSendBookingLimit()
    {
        return $this->SendBookingLimit;
    }
    /**
     * Set SendBookingLimit value
     * @param bool $sendBookingLimit
     * @return \StructType\HotelAvailRequest
     */
    public function setSendBookingLimit($sendBookingLimit = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendBookingLimit) && !is_bool($sendBookingLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendBookingLimit, true), gettype($sendBookingLimit)), __LINE__);
        }
        $this->SendBookingLimit = $sendBookingLimit;
        return $this;
    }
    /**
     * Get BookingLimitMessageType value
     * @return string|null
     */
    public function getBookingLimitMessageType()
    {
        return $this->BookingLimitMessageType;
    }
    /**
     * Set BookingLimitMessageType value
     * @param string $bookingLimitMessageType
     * @return \StructType\HotelAvailRequest
     */
    public function setBookingLimitMessageType($bookingLimitMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($bookingLimitMessageType) && !is_string($bookingLimitMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingLimitMessageType, true), gettype($bookingLimitMessageType)), __LINE__);
        }
        $this->BookingLimitMessageType = $bookingLimitMessageType;
        return $this;
    }
}
