<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelAvailRatePlanType StructType
 * @subpackage Structs
 */
class HotelAvailRatePlanType extends AbstractStructBase
{
    /**
     * The AvailStatusMessageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvailStatusMessageId;
    /**
     * The AvailStatusMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAvailStatusMessageType
     */
    public $AvailStatusMessages;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for HotelAvailRatePlanType
     * @uses HotelAvailRatePlanType::setAvailStatusMessageId()
     * @uses HotelAvailRatePlanType::setAvailStatusMessages()
     * @uses HotelAvailRatePlanType::setRatePlanCode()
     * @param string $availStatusMessageId
     * @param \ArrayType\ArrayOfAvailStatusMessageType $availStatusMessages
     * @param string $ratePlanCode
     */
    public function __construct($availStatusMessageId = null, \ArrayType\ArrayOfAvailStatusMessageType $availStatusMessages = null, $ratePlanCode = null)
    {
        $this
            ->setAvailStatusMessageId($availStatusMessageId)
            ->setAvailStatusMessages($availStatusMessages)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get AvailStatusMessageId value
     * @return string|null
     */
    public function getAvailStatusMessageId()
    {
        return $this->AvailStatusMessageId;
    }
    /**
     * Set AvailStatusMessageId value
     * @param string $availStatusMessageId
     * @return \StructType\HotelAvailRatePlanType
     */
    public function setAvailStatusMessageId($availStatusMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($availStatusMessageId) && !is_string($availStatusMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availStatusMessageId, true), gettype($availStatusMessageId)), __LINE__);
        }
        $this->AvailStatusMessageId = $availStatusMessageId;
        return $this;
    }
    /**
     * Get AvailStatusMessages value
     * @return \ArrayType\ArrayOfAvailStatusMessageType|null
     */
    public function getAvailStatusMessages()
    {
        return $this->AvailStatusMessages;
    }
    /**
     * Set AvailStatusMessages value
     * @param \ArrayType\ArrayOfAvailStatusMessageType $availStatusMessages
     * @return \StructType\HotelAvailRatePlanType
     */
    public function setAvailStatusMessages(\ArrayType\ArrayOfAvailStatusMessageType $availStatusMessages = null)
    {
        $this->AvailStatusMessages = $availStatusMessages;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\HotelAvailRatePlanType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
}
