<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeltaCandidate StructType
 * @subpackage Structs
 */
class DeltaCandidate extends AbstractStructBase
{
    /**
     * The SendAmount
     * @var bool
     */
    public $SendAmount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for DeltaCandidate
     * @uses DeltaCandidate::setSendAmount()
     * @uses DeltaCandidate::setCurrencyCode()
     * @uses DeltaCandidate::setDecimalPlaces()
     * @param bool $sendAmount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($sendAmount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setSendAmount($sendAmount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get SendAmount value
     * @return bool|null
     */
    public function getSendAmount()
    {
        return $this->SendAmount;
    }
    /**
     * Set SendAmount value
     * @param bool $sendAmount
     * @return \StructType\DeltaCandidate
     */
    public function setSendAmount($sendAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendAmount) && !is_bool($sendAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendAmount, true), gettype($sendAmount)), __LINE__);
        }
        $this->SendAmount = $sendAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\DeltaCandidate
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\DeltaCandidate
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
}
