<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for GuaranteeType EnumType
 * @subpackage Enumerations
 */
class GuaranteeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'GuaranteeRequired'
     * @return string 'GuaranteeRequired'
     */
    const VALUE_GUARANTEE_REQUIRED = 'GuaranteeRequired';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'CC/DC/Voucher'
     * @return string 'CC/DC/Voucher'
     */
    const VALUE_CC_DC_VOUCHER = 'CC/DC/Voucher';
    /**
     * Constant for value 'Profile'
     * @return string 'Profile'
     */
    const VALUE_PROFILE = 'Profile';
    /**
     * Constant for value 'Deposit'
     * @return string 'Deposit'
     */
    const VALUE_DEPOSIT = 'Deposit';
    /**
     * Constant for value 'PrePay'
     * @return string 'PrePay'
     */
    const VALUE_PRE_PAY = 'PrePay';
    /**
     * Constant for value 'DepositRequired'
     * @return string 'DepositRequired'
     */
    const VALUE_DEPOSIT_REQUIRED = 'DepositRequired';
    /**
     * Return allowed values
     * @uses self::VALUE_GUARANTEE_REQUIRED
     * @uses self::VALUE_NONE
     * @uses self::VALUE_CC_DC_VOUCHER
     * @uses self::VALUE_PROFILE
     * @uses self::VALUE_DEPOSIT
     * @uses self::VALUE_PRE_PAY
     * @uses self::VALUE_DEPOSIT_REQUIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GUARANTEE_REQUIRED,
            self::VALUE_NONE,
            self::VALUE_CC_DC_VOUCHER,
            self::VALUE_PROFILE,
            self::VALUE_DEPOSIT,
            self::VALUE_PRE_PAY,
            self::VALUE_DEPOSIT_REQUIRED,
        );
    }
}
