<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.travelline.ru/api/TLConnect.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.travelline.ru/api/TLConnect.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Hotel ServiceType
 */
$hotel = new \ServiceType\Hotel($options);
$hotel->setSoapHeaderSecurity($Security);
/**
 * Sample call for HotelAvailNotifRQ operation/method
 */
if ($hotel->HotelAvailNotifRQ(new \StructType\OTA_HotelAvailNotifRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelAvailRQ operation/method
 */
if ($hotel->HotelAvailRQ(new \StructType\OTA_HotelAvailRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelRatePlanNotifRQ operation/method
 */
if ($hotel->HotelRatePlanNotifRQ(new \StructType\OTA_HotelRatePlanNotifRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelRateAmountNotifRQ operation/method
 */
if ($hotel->HotelRateAmountNotifRQ(new \StructType\OTA_HotelRateAmountNotifRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelReadReservationRQ operation/method
 */
if ($hotel->HotelReadReservationRQ(new \StructType\OTA_ReadRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelInvNotifRQ operation/method
 */
if ($hotel->HotelInvNotifRQ(new \StructType\OTA_HotelInvNotifRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelDescriptiveInfoRQ operation/method
 */
if ($hotel->HotelDescriptiveInfoRQ(new \StructType\OTA_HotelDescriptiveInfoRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelResNotifRQ operation/method
 */
if ($hotel->HotelResNotifRQ(new \StructType\OTA_HotelResNotifRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelInvBlockNotifRQ operation/method
 */
if ($hotel->HotelInvBlockNotifRQ(new \StructType\OTA_HotelInvBlockNotifRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelInvCountNotifRQ operation/method
 */
if ($hotel->HotelInvCountNotifRQ(new \StructType\OTA_HotelInvCountNotifRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelRatePlanRQ operation/method
 */
if ($hotel->HotelRatePlanRQ(new \StructType\OTA_HotelRatePlanRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelAvailGetRQ operation/method
 */
if ($hotel->HotelAvailGetRQ(new \StructType\OTA_HotelAvailGetRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Samples for Notif ServiceType
 */
$notif = new \ServiceType\Notif($options);
$notif->setSoapHeaderSecurity($Security);
/**
 * Sample call for NotifReportRQ operation/method
 */
if ($notif->NotifReportRQ(new \StructType\OTA_NotifReportRQ()) !== false) {
    print_r($notif->getResult());
} else {
    print_r($notif->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
$cancel->setSoapHeaderSecurity($Security);
/**
 * Sample call for CancelRQ operation/method
 */
if ($cancel->CancelRQ(new \StructType\OTA_CancelRQ()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Profile ServiceType
 */
$profile = new \ServiceType\Profile($options);
$profile->setSoapHeaderSecurity($Security);
/**
 * Sample call for ProfileCreateRQ operation/method
 */
if ($profile->ProfileCreateRQ(new \StructType\OTA_ProfileCreateRQ()) !== false) {
    print_r($profile->getResult());
} else {
    print_r($profile->getLastError());
}
