<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStay StructType
 * @subpackage Structs
 */
class RoomStay extends RoomStayType
{
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The ServiceRPHs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfServiceRPHsTypeServiceRPH
     */
    public $ServiceRPHs;
    /**
     * The IndexNumber
     * @var int
     */
    public $IndexNumber;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $Reference;
    /**
     * The RoomStayCandidateRPH
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * The IsAlternate
     * @var bool
     */
    public $IsAlternate;
    /**
     * Constructor method for RoomStay
     * @uses RoomStay::setComments()
     * @uses RoomStay::setServiceRPHs()
     * @uses RoomStay::setIndexNumber()
     * @uses RoomStay::setReference()
     * @uses RoomStay::setRoomStayCandidateRPH()
     * @uses RoomStay::setIsAlternate()
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @param \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @param int $indexNumber
     * @param \StructType\Reference $reference
     * @param string $roomStayCandidateRPH
     * @param bool $isAlternate
     */
    public function __construct(\ArrayType\ArrayOfCommentTypeComment $comments = null, \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null, $indexNumber = null, \StructType\Reference $reference = null, $roomStayCandidateRPH = null, $isAlternate = null)
    {
        $this
            ->setComments($comments)
            ->setServiceRPHs($serviceRPHs)
            ->setIndexNumber($indexNumber)
            ->setReference($reference)
            ->setRoomStayCandidateRPH($roomStayCandidateRPH)
            ->setIsAlternate($isAlternate);
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @return \StructType\RoomStay
     */
    public function setComments(\ArrayType\ArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \ArrayType\ArrayOfServiceRPHsTypeServiceRPH|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @return \StructType\RoomStay
     */
    public function setServiceRPHs(\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \StructType\RoomStay
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !(is_int($indexNumber) || ctype_digit($indexNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexNumber, true), gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\Reference $reference
     * @return \StructType\RoomStay
     */
    public function setReference(\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \StructType\RoomStay
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayCandidateRPH, true), gettype($roomStayCandidateRPH)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Get IsAlternate value
     * @return bool|null
     */
    public function getIsAlternate()
    {
        return $this->IsAlternate;
    }
    /**
     * Set IsAlternate value
     * @param bool $isAlternate
     * @return \StructType\RoomStay
     */
    public function setIsAlternate($isAlternate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternate) && !is_bool($isAlternate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlternate, true), gettype($isAlternate)), __LINE__);
        }
        $this->IsAlternate = $isAlternate;
        return $this;
    }
}
