<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MethodInfo StructType
 * @subpackage Structs
 */
class MethodInfo extends AbstractStructBase
{
    /**
     * The BillingType
     * @var string
     */
    public $BillingType;
    /**
     * The SignFoodAndBev
     * @var bool
     */
    public $SignFoodAndBev;
    /**
     * The ReservationMethodCode
     * @var string
     */
    public $ReservationMethodCode;
    /**
     * Constructor method for MethodInfo
     * @uses MethodInfo::setBillingType()
     * @uses MethodInfo::setSignFoodAndBev()
     * @uses MethodInfo::setReservationMethodCode()
     * @param string $billingType
     * @param bool $signFoodAndBev
     * @param string $reservationMethodCode
     */
    public function __construct($billingType = null, $signFoodAndBev = null, $reservationMethodCode = null)
    {
        $this
            ->setBillingType($billingType)
            ->setSignFoodAndBev($signFoodAndBev)
            ->setReservationMethodCode($reservationMethodCode);
    }
    /**
     * Get BillingType value
     * @return string|null
     */
    public function getBillingType()
    {
        return $this->BillingType;
    }
    /**
     * Set BillingType value
     * @param string $billingType
     * @return \StructType\MethodInfo
     */
    public function setBillingType($billingType = null)
    {
        // validation for constraint: string
        if (!is_null($billingType) && !is_string($billingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingType, true), gettype($billingType)), __LINE__);
        }
        $this->BillingType = $billingType;
        return $this;
    }
    /**
     * Get SignFoodAndBev value
     * @return bool|null
     */
    public function getSignFoodAndBev()
    {
        return $this->SignFoodAndBev;
    }
    /**
     * Set SignFoodAndBev value
     * @param bool $signFoodAndBev
     * @return \StructType\MethodInfo
     */
    public function setSignFoodAndBev($signFoodAndBev = null)
    {
        // validation for constraint: boolean
        if (!is_null($signFoodAndBev) && !is_bool($signFoodAndBev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signFoodAndBev, true), gettype($signFoodAndBev)), __LINE__);
        }
        $this->SignFoodAndBev = $signFoodAndBev;
        return $this;
    }
    /**
     * Get ReservationMethodCode value
     * @return string|null
     */
    public function getReservationMethodCode()
    {
        return $this->ReservationMethodCode;
    }
    /**
     * Set ReservationMethodCode value
     * @param string $reservationMethodCode
     * @return \StructType\MethodInfo
     */
    public function setReservationMethodCode($reservationMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($reservationMethodCode) && !is_string($reservationMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationMethodCode, true), gettype($reservationMethodCode)), __LINE__);
        }
        $this->ReservationMethodCode = $reservationMethodCode;
        return $this;
    }
}
