<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealsIncluded StructType
 * @subpackage Structs
 */
class MealsIncluded extends AbstractStructBase
{
    /**
     * The Breakfast
     * @var bool
     */
    public $Breakfast;
    /**
     * The Lunch
     * @var bool
     */
    public $Lunch;
    /**
     * The Dinner
     * @var bool
     */
    public $Dinner;
    /**
     * The MealPlanIndicator
     * @var bool
     */
    public $MealPlanIndicator;
    /**
     * The MealPlanCodes
     * @var string[]
     */
    public $MealPlanCodes;
    /**
     * Constructor method for MealsIncluded
     * @uses MealsIncluded::setBreakfast()
     * @uses MealsIncluded::setLunch()
     * @uses MealsIncluded::setDinner()
     * @uses MealsIncluded::setMealPlanIndicator()
     * @uses MealsIncluded::setMealPlanCodes()
     * @param bool $breakfast
     * @param bool $lunch
     * @param bool $dinner
     * @param bool $mealPlanIndicator
     * @param string[] $mealPlanCodes
     */
    public function __construct($breakfast = null, $lunch = null, $dinner = null, $mealPlanIndicator = null, array $mealPlanCodes = array())
    {
        $this
            ->setBreakfast($breakfast)
            ->setLunch($lunch)
            ->setDinner($dinner)
            ->setMealPlanIndicator($mealPlanIndicator)
            ->setMealPlanCodes($mealPlanCodes);
    }
    /**
     * Get Breakfast value
     * @return bool|null
     */
    public function getBreakfast()
    {
        return $this->Breakfast;
    }
    /**
     * Set Breakfast value
     * @param bool $breakfast
     * @return \StructType\MealsIncluded
     */
    public function setBreakfast($breakfast = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakfast) && !is_bool($breakfast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($breakfast, true), gettype($breakfast)), __LINE__);
        }
        $this->Breakfast = $breakfast;
        return $this;
    }
    /**
     * Get Lunch value
     * @return bool|null
     */
    public function getLunch()
    {
        return $this->Lunch;
    }
    /**
     * Set Lunch value
     * @param bool $lunch
     * @return \StructType\MealsIncluded
     */
    public function setLunch($lunch = null)
    {
        // validation for constraint: boolean
        if (!is_null($lunch) && !is_bool($lunch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lunch, true), gettype($lunch)), __LINE__);
        }
        $this->Lunch = $lunch;
        return $this;
    }
    /**
     * Get Dinner value
     * @return bool|null
     */
    public function getDinner()
    {
        return $this->Dinner;
    }
    /**
     * Set Dinner value
     * @param bool $dinner
     * @return \StructType\MealsIncluded
     */
    public function setDinner($dinner = null)
    {
        // validation for constraint: boolean
        if (!is_null($dinner) && !is_bool($dinner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dinner, true), gettype($dinner)), __LINE__);
        }
        $this->Dinner = $dinner;
        return $this;
    }
    /**
     * Get MealPlanIndicator value
     * @return bool|null
     */
    public function getMealPlanIndicator()
    {
        return $this->MealPlanIndicator;
    }
    /**
     * Set MealPlanIndicator value
     * @param bool $mealPlanIndicator
     * @return \StructType\MealsIncluded
     */
    public function setMealPlanIndicator($mealPlanIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($mealPlanIndicator) && !is_bool($mealPlanIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mealPlanIndicator, true), gettype($mealPlanIndicator)), __LINE__);
        }
        $this->MealPlanIndicator = $mealPlanIndicator;
        return $this;
    }
    /**
     * Get MealPlanCodes value
     * @return string[]|null
     */
    public function getMealPlanCodes()
    {
        return $this->MealPlanCodes;
    }
    /**
     * This method is responsible for validating the values passed to the setMealPlanCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMealPlanCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealPlanCodesForArrayConstraintsFromSetMealPlanCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mealsIncludedMealPlanCodesItem) {
            // validation for constraint: itemType
            if (!is_string($mealsIncludedMealPlanCodesItem)) {
                $invalidValues[] = is_object($mealsIncludedMealPlanCodesItem) ? get_class($mealsIncludedMealPlanCodesItem) : sprintf('%s(%s)', gettype($mealsIncludedMealPlanCodesItem), var_export($mealsIncludedMealPlanCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MealPlanCodes property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MealPlanCodes value
     * @throws \InvalidArgumentException
     * @param string[] $mealPlanCodes
     * @return \StructType\MealsIncluded
     */
    public function setMealPlanCodes(array $mealPlanCodes = array())
    {
        // validation for constraint: array
        if ('' !== ($mealPlanCodesArrayErrorMessage = self::validateMealPlanCodesForArrayConstraintsFromSetMealPlanCodes($mealPlanCodes))) {
            throw new \InvalidArgumentException($mealPlanCodesArrayErrorMessage, __LINE__);
        }
        $this->MealPlanCodes = $mealPlanCodes;
        return $this;
    }
    /**
     * Add item to MealPlanCodes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MealsIncluded
     */
    public function addToMealPlanCodes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MealPlanCodes property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MealPlanCodes[] = $item;
        return $this;
    }
}
