<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Issuer StructType
 * @subpackage Structs
 */
class Issuer extends List_PaymentCardIssuer
{
    /**
     * The _
     * @var \StructType\List_PaymentCardIssuer
     */
    public $_;
    /**
     * The BankID
     * @var string
     */
    public $BankID;
    /**
     * Constructor method for Issuer
     * @uses Issuer::set_()
     * @uses Issuer::setBankID()
     * @param \StructType\List_PaymentCardIssuer $_
     * @param string $bankID
     */
    public function __construct(\StructType\List_PaymentCardIssuer $_ = null, $bankID = null)
    {
        $this
            ->set_($_)
            ->setBankID($bankID);
    }
    /**
     * Get _ value
     * @return \StructType\List_PaymentCardIssuer|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\List_PaymentCardIssuer $_
     * @return \StructType\Issuer
     */
    public function set_(\StructType\List_PaymentCardIssuer $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get BankID value
     * @return string|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param string $bankID
     * @return \StructType\Issuer
     */
    public function setBankID($bankID = null)
    {
        // validation for constraint: string
        if (!is_null($bankID) && !is_string($bankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankID, true), gettype($bankID)), __LINE__);
        }
        $this->BankID = $bankID;
        return $this;
    }
}
