<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservation StructType
 * @subpackage Structs
 */
class HotelReservation extends HotelReservationType
{
    /**
     * The WarningRPH
     * @var string[]
     */
    public $WarningRPH;
    /**
     * Constructor method for HotelReservation
     * @uses HotelReservation::setWarningRPH()
     * @param string[] $warningRPH
     */
    public function __construct(array $warningRPH = array())
    {
        $this
            ->setWarningRPH($warningRPH);
    }
    /**
     * Get WarningRPH value
     * @return string[]|null
     */
    public function getWarningRPH()
    {
        return $this->WarningRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setWarningRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarningRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningRPHForArrayConstraintsFromSetWarningRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelReservationWarningRPHItem) {
            // validation for constraint: itemType
            if (!is_string($hotelReservationWarningRPHItem)) {
                $invalidValues[] = is_object($hotelReservationWarningRPHItem) ? get_class($hotelReservationWarningRPHItem) : sprintf('%s(%s)', gettype($hotelReservationWarningRPHItem), var_export($hotelReservationWarningRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WarningRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WarningRPH value
     * @throws \InvalidArgumentException
     * @param string[] $warningRPH
     * @return \StructType\HotelReservation
     */
    public function setWarningRPH(array $warningRPH = array())
    {
        // validation for constraint: array
        if ('' !== ($warningRPHArrayErrorMessage = self::validateWarningRPHForArrayConstraintsFromSetWarningRPH($warningRPH))) {
            throw new \InvalidArgumentException($warningRPHArrayErrorMessage, __LINE__);
        }
        $this->WarningRPH = $warningRPH;
        return $this;
    }
    /**
     * Add item to WarningRPH value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\HotelReservation
     */
    public function addToWarningRPH($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The WarningRPH property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WarningRPH[] = $item;
        return $this;
    }
}
