<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRatePlanType StructType
 * @subpackage Structs
 */
class HotelRatePlanType extends AbstractStructBase
{
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotelRatePlanRSMessageTypeRate
     */
    public $Rates;
    /**
     * The RateAmountMessageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateAmountMessageId;
    /**
     * The DestinationSystemsCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotelRatePlanTypeDestinationSystemCode
     */
    public $DestinationSystemsCode;
    /**
     * The Supplements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotelRatePlanTypeSupplementPrerequisiteInventory
     */
    public $Supplements;
    /**
     * The SellableProducts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSellableProductsTypeSellableProduct
     */
    public $SellableProducts;
    /**
     * The RatePlanLevelFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RatePlanLevelFee
     */
    public $RatePlanLevelFee;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The RatePlanType
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanQualifier
     * @var bool
     */
    public $RatePlanQualifier;
    /**
     * The RatePlanCategory
     * @var string
     */
    public $RatePlanCategory;
    /**
     * The RatePlanCodeType
     * @var string
     */
    public $RatePlanCodeType;
    /**
     * The RatePlanNotifType
     * @var string
     */
    public $RatePlanNotifType;
    /**
     * The RatePlanStatusType
     * @var string
     */
    public $RatePlanStatusType;
    /**
     * The RatePlanNotifScopeType
     * @var string
     */
    public $RatePlanNotifScopeType;
    /**
     * The BaseRatePlanCode
     * @var string
     */
    public $BaseRatePlanCode;
    /**
     * The AdjustedAmount
     * @var float
     */
    public $AdjustedAmount;
    /**
     * The AdjustedPercentage
     * @var float
     */
    public $AdjustedPercentage;
    /**
     * Constructor method for HotelRatePlanType
     * @uses HotelRatePlanType::setRates()
     * @uses HotelRatePlanType::setRateAmountMessageId()
     * @uses HotelRatePlanType::setDestinationSystemsCode()
     * @uses HotelRatePlanType::setSupplements()
     * @uses HotelRatePlanType::setSellableProducts()
     * @uses HotelRatePlanType::setRatePlanLevelFee()
     * @uses HotelRatePlanType::setDescription()
     * @uses HotelRatePlanType::setUniqueID()
     * @uses HotelRatePlanType::setHotelRef()
     * @uses HotelRatePlanType::setStart()
     * @uses HotelRatePlanType::setDuration()
     * @uses HotelRatePlanType::setEnd()
     * @uses HotelRatePlanType::setCurrencyCode()
     * @uses HotelRatePlanType::setDecimalPlaces()
     * @uses HotelRatePlanType::setRatePlanType()
     * @uses HotelRatePlanType::setRatePlanCode()
     * @uses HotelRatePlanType::setRatePlanID()
     * @uses HotelRatePlanType::setRatePlanQualifier()
     * @uses HotelRatePlanType::setRatePlanCategory()
     * @uses HotelRatePlanType::setRatePlanCodeType()
     * @uses HotelRatePlanType::setRatePlanNotifType()
     * @uses HotelRatePlanType::setRatePlanStatusType()
     * @uses HotelRatePlanType::setRatePlanNotifScopeType()
     * @uses HotelRatePlanType::setBaseRatePlanCode()
     * @uses HotelRatePlanType::setAdjustedAmount()
     * @uses HotelRatePlanType::setAdjustedPercentage()
     * @param \ArrayType\ArrayOfHotelRatePlanRSMessageTypeRate $rates
     * @param string $rateAmountMessageId
     * @param \ArrayType\ArrayOfHotelRatePlanTypeDestinationSystemCode $destinationSystemsCode
     * @param \ArrayType\ArrayOfHotelRatePlanTypeSupplementPrerequisiteInventory $supplements
     * @param \ArrayType\ArrayOfSellableProductsTypeSellableProduct $sellableProducts
     * @param \StructType\RatePlanLevelFee $ratePlanLevelFee
     * @param \StructType\ParagraphType[] $description
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\HotelRef $hotelRef
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $ratePlanType
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param bool $ratePlanQualifier
     * @param string $ratePlanCategory
     * @param string $ratePlanCodeType
     * @param string $ratePlanNotifType
     * @param string $ratePlanStatusType
     * @param string $ratePlanNotifScopeType
     * @param string $baseRatePlanCode
     * @param float $adjustedAmount
     * @param float $adjustedPercentage
     */
    public function __construct(\ArrayType\ArrayOfHotelRatePlanRSMessageTypeRate $rates = null, $rateAmountMessageId = null, \ArrayType\ArrayOfHotelRatePlanTypeDestinationSystemCode $destinationSystemsCode = null, \ArrayType\ArrayOfHotelRatePlanTypeSupplementPrerequisiteInventory $supplements = null, \ArrayType\ArrayOfSellableProductsTypeSellableProduct $sellableProducts = null, \StructType\RatePlanLevelFee $ratePlanLevelFee = null, array $description = array(), \StructType\UniqueID_Type $uniqueID = null, \StructType\HotelRef $hotelRef = null, $start = null, $duration = null, $end = null, $currencyCode = null, $decimalPlaces = null, $ratePlanType = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanQualifier = null, $ratePlanCategory = null, $ratePlanCodeType = null, $ratePlanNotifType = null, $ratePlanStatusType = null, $ratePlanNotifScopeType = null, $baseRatePlanCode = null, $adjustedAmount = null, $adjustedPercentage = null)
    {
        $this
            ->setRates($rates)
            ->setRateAmountMessageId($rateAmountMessageId)
            ->setDestinationSystemsCode($destinationSystemsCode)
            ->setSupplements($supplements)
            ->setSellableProducts($sellableProducts)
            ->setRatePlanLevelFee($ratePlanLevelFee)
            ->setDescription($description)
            ->setUniqueID($uniqueID)
            ->setHotelRef($hotelRef)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanQualifier($ratePlanQualifier)
            ->setRatePlanCategory($ratePlanCategory)
            ->setRatePlanCodeType($ratePlanCodeType)
            ->setRatePlanNotifType($ratePlanNotifType)
            ->setRatePlanStatusType($ratePlanStatusType)
            ->setRatePlanNotifScopeType($ratePlanNotifScopeType)
            ->setBaseRatePlanCode($baseRatePlanCode)
            ->setAdjustedAmount($adjustedAmount)
            ->setAdjustedPercentage($adjustedPercentage);
    }
    /**
     * Get Rates value
     * @return \ArrayType\ArrayOfHotelRatePlanRSMessageTypeRate|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \ArrayType\ArrayOfHotelRatePlanRSMessageTypeRate $rates
     * @return \StructType\HotelRatePlanType
     */
    public function setRates(\ArrayType\ArrayOfHotelRatePlanRSMessageTypeRate $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get RateAmountMessageId value
     * @return string|null
     */
    public function getRateAmountMessageId()
    {
        return $this->RateAmountMessageId;
    }
    /**
     * Set RateAmountMessageId value
     * @param string $rateAmountMessageId
     * @return \StructType\HotelRatePlanType
     */
    public function setRateAmountMessageId($rateAmountMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($rateAmountMessageId) && !is_string($rateAmountMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateAmountMessageId, true), gettype($rateAmountMessageId)), __LINE__);
        }
        $this->RateAmountMessageId = $rateAmountMessageId;
        return $this;
    }
    /**
     * Get DestinationSystemsCode value
     * @return \ArrayType\ArrayOfHotelRatePlanTypeDestinationSystemCode|null
     */
    public function getDestinationSystemsCode()
    {
        return $this->DestinationSystemsCode;
    }
    /**
     * Set DestinationSystemsCode value
     * @param \ArrayType\ArrayOfHotelRatePlanTypeDestinationSystemCode $destinationSystemsCode
     * @return \StructType\HotelRatePlanType
     */
    public function setDestinationSystemsCode(\ArrayType\ArrayOfHotelRatePlanTypeDestinationSystemCode $destinationSystemsCode = null)
    {
        $this->DestinationSystemsCode = $destinationSystemsCode;
        return $this;
    }
    /**
     * Get Supplements value
     * @return \ArrayType\ArrayOfHotelRatePlanTypeSupplementPrerequisiteInventory|null
     */
    public function getSupplements()
    {
        return $this->Supplements;
    }
    /**
     * Set Supplements value
     * @param \ArrayType\ArrayOfHotelRatePlanTypeSupplementPrerequisiteInventory $supplements
     * @return \StructType\HotelRatePlanType
     */
    public function setSupplements(\ArrayType\ArrayOfHotelRatePlanTypeSupplementPrerequisiteInventory $supplements = null)
    {
        $this->Supplements = $supplements;
        return $this;
    }
    /**
     * Get SellableProducts value
     * @return \ArrayType\ArrayOfSellableProductsTypeSellableProduct|null
     */
    public function getSellableProducts()
    {
        return $this->SellableProducts;
    }
    /**
     * Set SellableProducts value
     * @param \ArrayType\ArrayOfSellableProductsTypeSellableProduct $sellableProducts
     * @return \StructType\HotelRatePlanType
     */
    public function setSellableProducts(\ArrayType\ArrayOfSellableProductsTypeSellableProduct $sellableProducts = null)
    {
        $this->SellableProducts = $sellableProducts;
        return $this;
    }
    /**
     * Get RatePlanLevelFee value
     * @return \StructType\RatePlanLevelFee|null
     */
    public function getRatePlanLevelFee()
    {
        return $this->RatePlanLevelFee;
    }
    /**
     * Set RatePlanLevelFee value
     * @param \StructType\RatePlanLevelFee $ratePlanLevelFee
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanLevelFee(\StructType\RatePlanLevelFee $ratePlanLevelFee = null)
    {
        $this->RatePlanLevelFee = $ratePlanLevelFee;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelRatePlanTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$hotelRatePlanTypeDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($hotelRatePlanTypeDescriptionItem) ? get_class($hotelRatePlanTypeDescriptionItem) : sprintf('%s(%s)', gettype($hotelRatePlanTypeDescriptionItem), var_export($hotelRatePlanTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $description
     * @return \StructType\HotelRatePlanType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\HotelRatePlanType
     */
    public function addToDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\HotelRatePlanType
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\HotelRatePlanType
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\HotelRatePlanType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\HotelRatePlanType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\HotelRatePlanType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\HotelRatePlanType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\HotelRatePlanType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanQualifier value
     * @return bool|null
     */
    public function getRatePlanQualifier()
    {
        return $this->RatePlanQualifier;
    }
    /**
     * Set RatePlanQualifier value
     * @param bool $ratePlanQualifier
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanQualifier($ratePlanQualifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($ratePlanQualifier) && !is_bool($ratePlanQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ratePlanQualifier, true), gettype($ratePlanQualifier)), __LINE__);
        }
        $this->RatePlanQualifier = $ratePlanQualifier;
        return $this;
    }
    /**
     * Get RatePlanCategory value
     * @return string|null
     */
    public function getRatePlanCategory()
    {
        return $this->RatePlanCategory;
    }
    /**
     * Set RatePlanCategory value
     * @param string $ratePlanCategory
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanCategory($ratePlanCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCategory) && !is_string($ratePlanCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCategory, true), gettype($ratePlanCategory)), __LINE__);
        }
        $this->RatePlanCategory = $ratePlanCategory;
        return $this;
    }
    /**
     * Get RatePlanCodeType value
     * @return string|null
     */
    public function getRatePlanCodeType()
    {
        return $this->RatePlanCodeType;
    }
    /**
     * Set RatePlanCodeType value
     * @param string $ratePlanCodeType
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanCodeType($ratePlanCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCodeType) && !is_string($ratePlanCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCodeType, true), gettype($ratePlanCodeType)), __LINE__);
        }
        $this->RatePlanCodeType = $ratePlanCodeType;
        return $this;
    }
    /**
     * Get RatePlanNotifType value
     * @return string|null
     */
    public function getRatePlanNotifType()
    {
        return $this->RatePlanNotifType;
    }
    /**
     * Set RatePlanNotifType value
     * @param string $ratePlanNotifType
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanNotifType($ratePlanNotifType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanNotifType) && !is_string($ratePlanNotifType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanNotifType, true), gettype($ratePlanNotifType)), __LINE__);
        }
        $this->RatePlanNotifType = $ratePlanNotifType;
        return $this;
    }
    /**
     * Get RatePlanStatusType value
     * @return string|null
     */
    public function getRatePlanStatusType()
    {
        return $this->RatePlanStatusType;
    }
    /**
     * Set RatePlanStatusType value
     * @param string $ratePlanStatusType
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanStatusType($ratePlanStatusType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanStatusType) && !is_string($ratePlanStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanStatusType, true), gettype($ratePlanStatusType)), __LINE__);
        }
        $this->RatePlanStatusType = $ratePlanStatusType;
        return $this;
    }
    /**
     * Get RatePlanNotifScopeType value
     * @return string|null
     */
    public function getRatePlanNotifScopeType()
    {
        return $this->RatePlanNotifScopeType;
    }
    /**
     * Set RatePlanNotifScopeType value
     * @param string $ratePlanNotifScopeType
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanNotifScopeType($ratePlanNotifScopeType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanNotifScopeType) && !is_string($ratePlanNotifScopeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanNotifScopeType, true), gettype($ratePlanNotifScopeType)), __LINE__);
        }
        $this->RatePlanNotifScopeType = $ratePlanNotifScopeType;
        return $this;
    }
    /**
     * Get BaseRatePlanCode value
     * @return string|null
     */
    public function getBaseRatePlanCode()
    {
        return $this->BaseRatePlanCode;
    }
    /**
     * Set BaseRatePlanCode value
     * @param string $baseRatePlanCode
     * @return \StructType\HotelRatePlanType
     */
    public function setBaseRatePlanCode($baseRatePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($baseRatePlanCode) && !is_string($baseRatePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseRatePlanCode, true), gettype($baseRatePlanCode)), __LINE__);
        }
        $this->BaseRatePlanCode = $baseRatePlanCode;
        return $this;
    }
    /**
     * Get AdjustedAmount value
     * @return float|null
     */
    public function getAdjustedAmount()
    {
        return $this->AdjustedAmount;
    }
    /**
     * Set AdjustedAmount value
     * @param float $adjustedAmount
     * @return \StructType\HotelRatePlanType
     */
    public function setAdjustedAmount($adjustedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($adjustedAmount) && !(is_float($adjustedAmount) || is_numeric($adjustedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustedAmount, true), gettype($adjustedAmount)), __LINE__);
        }
        $this->AdjustedAmount = $adjustedAmount;
        return $this;
    }
    /**
     * Get AdjustedPercentage value
     * @return float|null
     */
    public function getAdjustedPercentage()
    {
        return $this->AdjustedPercentage;
    }
    /**
     * Set AdjustedPercentage value
     * @param float $adjustedPercentage
     * @return \StructType\HotelRatePlanType
     */
    public function setAdjustedPercentage($adjustedPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($adjustedPercentage) && !(is_float($adjustedPercentage) || is_numeric($adjustedPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustedPercentage, true), gettype($adjustedPercentage)), __LINE__);
        }
        $this->AdjustedPercentage = $adjustedPercentage;
        return $this;
    }
}
