<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestAvailableRateCandidate StructType
 * @subpackage Structs
 */
class BestAvailableRateCandidate extends AbstractStructBase
{
    /**
     * The SendLengthOfStayTime
     * @var bool
     */
    public $SendLengthOfStayTime;
    /**
     * The SendRatePlanCode
     * @var bool
     */
    public $SendRatePlanCode;
    /**
     * The SendAmount
     * @var bool
     */
    public $SendAmount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for BestAvailableRateCandidate
     * @uses BestAvailableRateCandidate::setSendLengthOfStayTime()
     * @uses BestAvailableRateCandidate::setSendRatePlanCode()
     * @uses BestAvailableRateCandidate::setSendAmount()
     * @uses BestAvailableRateCandidate::setCurrencyCode()
     * @uses BestAvailableRateCandidate::setDecimalPlaces()
     * @param bool $sendLengthOfStayTime
     * @param bool $sendRatePlanCode
     * @param bool $sendAmount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($sendLengthOfStayTime = null, $sendRatePlanCode = null, $sendAmount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setSendLengthOfStayTime($sendLengthOfStayTime)
            ->setSendRatePlanCode($sendRatePlanCode)
            ->setSendAmount($sendAmount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get SendLengthOfStayTime value
     * @return bool|null
     */
    public function getSendLengthOfStayTime()
    {
        return $this->SendLengthOfStayTime;
    }
    /**
     * Set SendLengthOfStayTime value
     * @param bool $sendLengthOfStayTime
     * @return \StructType\BestAvailableRateCandidate
     */
    public function setSendLengthOfStayTime($sendLengthOfStayTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendLengthOfStayTime) && !is_bool($sendLengthOfStayTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendLengthOfStayTime, true), gettype($sendLengthOfStayTime)), __LINE__);
        }
        $this->SendLengthOfStayTime = $sendLengthOfStayTime;
        return $this;
    }
    /**
     * Get SendRatePlanCode value
     * @return bool|null
     */
    public function getSendRatePlanCode()
    {
        return $this->SendRatePlanCode;
    }
    /**
     * Set SendRatePlanCode value
     * @param bool $sendRatePlanCode
     * @return \StructType\BestAvailableRateCandidate
     */
    public function setSendRatePlanCode($sendRatePlanCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendRatePlanCode) && !is_bool($sendRatePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendRatePlanCode, true), gettype($sendRatePlanCode)), __LINE__);
        }
        $this->SendRatePlanCode = $sendRatePlanCode;
        return $this;
    }
    /**
     * Get SendAmount value
     * @return bool|null
     */
    public function getSendAmount()
    {
        return $this->SendAmount;
    }
    /**
     * Set SendAmount value
     * @param bool $sendAmount
     * @return \StructType\BestAvailableRateCandidate
     */
    public function setSendAmount($sendAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendAmount) && !is_bool($sendAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendAmount, true), gettype($sendAmount)), __LINE__);
        }
        $this->SendAmount = $sendAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\BestAvailableRateCandidate
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\BestAvailableRateCandidate
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
}
