<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Notif ServiceType
 * @subpackage Services
 */
class Notif extends AbstractSoapClientBase
{
    /**
     * Sets the Security SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param Security $security
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurity(Security $security, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Security', $security, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named NotifReportRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_NotifReportRQ $oTA_NotifReportRQ
     * @return \StructType\MessageAcknowledgementType|bool
     */
    public function NotifReportRQ(\StructType\OTA_NotifReportRQ $oTA_NotifReportRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->NotifReportRQ($oTA_NotifReportRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageAcknowledgementType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
