<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationType StructType
 * @subpackage Structs
 */
class HotelReservationType extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSourceType
     */
    public $POS;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The RoomStays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomStaysTypeRoomStay
     */
    public $RoomStays;
    /**
     * The ResGuests
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfResGuestType
     */
    public $ResGuests;
    /**
     * The ResGlobalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResGlobalInfoType
     */
    public $ResGlobalInfo;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfServiceType
     */
    public $Services;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * The ForcedSellIndicator
     * @var bool
     */
    public $ForcedSellIndicator;
    /**
     * The RateOverrideIndicator
     * @var bool
     */
    public $RateOverrideIndicator;
    /**
     * Constructor method for HotelReservationType
     * @uses HotelReservationType::setPOS()
     * @uses HotelReservationType::setUniqueID()
     * @uses HotelReservationType::setRoomStays()
     * @uses HotelReservationType::setResGuests()
     * @uses HotelReservationType::setResGlobalInfo()
     * @uses HotelReservationType::setServices()
     * @uses HotelReservationType::setTPA_Extensions()
     * @uses HotelReservationType::setCreateDateTime()
     * @uses HotelReservationType::setCreatorID()
     * @uses HotelReservationType::setLastModifyDateTime()
     * @uses HotelReservationType::setResStatus()
     * @uses HotelReservationType::setForcedSellIndicator()
     * @uses HotelReservationType::setRateOverrideIndicator()
     * @param \ArrayType\ArrayOfSourceType $pOS
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @param \ArrayType\ArrayOfRoomStaysTypeRoomStay $roomStays
     * @param \ArrayType\ArrayOfResGuestType $resGuests
     * @param \StructType\ResGlobalInfoType $resGlobalInfo
     * @param \ArrayType\ArrayOfServiceType $services
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $resStatus
     * @param bool $forcedSellIndicator
     * @param bool $rateOverrideIndicator
     */
    public function __construct(\ArrayType\ArrayOfSourceType $pOS = null, array $uniqueID = array(), \ArrayType\ArrayOfRoomStaysTypeRoomStay $roomStays = null, \ArrayType\ArrayOfResGuestType $resGuests = null, \StructType\ResGlobalInfoType $resGlobalInfo = null, \ArrayType\ArrayOfServiceType $services = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $resStatus = null, $forcedSellIndicator = null, $rateOverrideIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setUniqueID($uniqueID)
            ->setRoomStays($roomStays)
            ->setResGuests($resGuests)
            ->setResGlobalInfo($resGlobalInfo)
            ->setServices($services)
            ->setTPA_Extensions($tPA_Extensions)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setResStatus($resStatus)
            ->setForcedSellIndicator($forcedSellIndicator)
            ->setRateOverrideIndicator($rateOverrideIndicator);
    }
    /**
     * Get POS value
     * @return \ArrayType\ArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \ArrayType\ArrayOfSourceType $pOS
     * @return \StructType\HotelReservationType
     */
    public function setPOS(\ArrayType\ArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelReservationTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$hotelReservationTypeUniqueIDItem instanceof \StructType\UniqueID_Type) {
                $invalidValues[] = is_object($hotelReservationTypeUniqueIDItem) ? get_class($hotelReservationTypeUniqueIDItem) : sprintf('%s(%s)', gettype($hotelReservationTypeUniqueIDItem), var_export($hotelReservationTypeUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @return \StructType\HotelReservationType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\HotelReservationType
     */
    public function addToUniqueID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get RoomStays value
     * @return \ArrayType\ArrayOfRoomStaysTypeRoomStay|null
     */
    public function getRoomStays()
    {
        return $this->RoomStays;
    }
    /**
     * Set RoomStays value
     * @param \ArrayType\ArrayOfRoomStaysTypeRoomStay $roomStays
     * @return \StructType\HotelReservationType
     */
    public function setRoomStays(\ArrayType\ArrayOfRoomStaysTypeRoomStay $roomStays = null)
    {
        $this->RoomStays = $roomStays;
        return $this;
    }
    /**
     * Get ResGuests value
     * @return \ArrayType\ArrayOfResGuestType|null
     */
    public function getResGuests()
    {
        return $this->ResGuests;
    }
    /**
     * Set ResGuests value
     * @param \ArrayType\ArrayOfResGuestType $resGuests
     * @return \StructType\HotelReservationType
     */
    public function setResGuests(\ArrayType\ArrayOfResGuestType $resGuests = null)
    {
        $this->ResGuests = $resGuests;
        return $this;
    }
    /**
     * Get ResGlobalInfo value
     * @return \StructType\ResGlobalInfoType|null
     */
    public function getResGlobalInfo()
    {
        return $this->ResGlobalInfo;
    }
    /**
     * Set ResGlobalInfo value
     * @param \StructType\ResGlobalInfoType $resGlobalInfo
     * @return \StructType\HotelReservationType
     */
    public function setResGlobalInfo(\StructType\ResGlobalInfoType $resGlobalInfo = null)
    {
        $this->ResGlobalInfo = $resGlobalInfo;
        return $this;
    }
    /**
     * Get Services value
     * @return \ArrayType\ArrayOfServiceType|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \ArrayType\ArrayOfServiceType $services
     * @return \StructType\HotelReservationType
     */
    public function setServices(\ArrayType\ArrayOfServiceType $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\HotelReservationType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\HotelReservationType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \StructType\HotelReservationType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \StructType\HotelReservationType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @param string $resStatus
     * @return \StructType\HotelReservationType
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: string
        if (!is_null($resStatus) && !is_string($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resStatus, true), gettype($resStatus)), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Get ForcedSellIndicator value
     * @return bool|null
     */
    public function getForcedSellIndicator()
    {
        return $this->ForcedSellIndicator;
    }
    /**
     * Set ForcedSellIndicator value
     * @param bool $forcedSellIndicator
     * @return \StructType\HotelReservationType
     */
    public function setForcedSellIndicator($forcedSellIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($forcedSellIndicator) && !is_bool($forcedSellIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forcedSellIndicator, true), gettype($forcedSellIndicator)), __LINE__);
        }
        $this->ForcedSellIndicator = $forcedSellIndicator;
        return $this;
    }
    /**
     * Get RateOverrideIndicator value
     * @return bool|null
     */
    public function getRateOverrideIndicator()
    {
        return $this->RateOverrideIndicator;
    }
    /**
     * Set RateOverrideIndicator value
     * @param bool $rateOverrideIndicator
     * @return \StructType\HotelReservationType
     */
    public function setRateOverrideIndicator($rateOverrideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateOverrideIndicator) && !is_bool($rateOverrideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateOverrideIndicator, true), gettype($rateOverrideIndicator)), __LINE__);
        }
        $this->RateOverrideIndicator = $rateOverrideIndicator;
        return $this;
    }
}
