<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fee StructType
 * @subpackage Structs
 */
class Fee extends FeeType
{
    /**
     * The MealPlanCode
     * @var string
     */
    public $MealPlanCode;
    /**
     * Constructor method for Fee
     * @uses Fee::setMealPlanCode()
     * @param string $mealPlanCode
     */
    public function __construct($mealPlanCode = null)
    {
        $this
            ->setMealPlanCode($mealPlanCode);
    }
    /**
     * Get MealPlanCode value
     * @return string|null
     */
    public function getMealPlanCode()
    {
        return $this->MealPlanCode;
    }
    /**
     * Set MealPlanCode value
     * @param string $mealPlanCode
     * @return \StructType\Fee
     */
    public function setMealPlanCode($mealPlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealPlanCode) && !is_string($mealPlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mealPlanCode, true), gettype($mealPlanCode)), __LINE__);
        }
        $this->MealPlanCode = $mealPlanCode;
        return $this;
    }
}
