<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRange StructType
 * @subpackage Structs
 */
class RateRange extends AbstractStructBase
{
    /**
     * The RoomStayCandidateRPH
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * The MinRate
     * @var float
     */
    public $MinRate;
    /**
     * The MaxRate
     * @var float
     */
    public $MaxRate;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for RateRange
     * @uses RateRange::setRoomStayCandidateRPH()
     * @uses RateRange::setMinRate()
     * @uses RateRange::setMaxRate()
     * @uses RateRange::setCurrencyCode()
     * @param string $roomStayCandidateRPH
     * @param float $minRate
     * @param float $maxRate
     * @param string $currencyCode
     */
    public function __construct($roomStayCandidateRPH = null, $minRate = null, $maxRate = null, $currencyCode = null)
    {
        $this
            ->setRoomStayCandidateRPH($roomStayCandidateRPH)
            ->setMinRate($minRate)
            ->setMaxRate($maxRate)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \StructType\RateRange
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayCandidateRPH, true), gettype($roomStayCandidateRPH)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Get MinRate value
     * @return float|null
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \StructType\RateRange
     */
    public function setMinRate($minRate = null)
    {
        // validation for constraint: float
        if (!is_null($minRate) && !(is_float($minRate) || is_numeric($minRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minRate, true), gettype($minRate)), __LINE__);
        }
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float|null
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \StructType\RateRange
     */
    public function setMaxRate($maxRate = null)
    {
        // validation for constraint: float
        if (!is_null($maxRate) && !(is_float($maxRate) || is_numeric($maxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxRate, true), gettype($maxRate)), __LINE__);
        }
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\RateRange
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
}
