<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileInfo StructType
 * @subpackage Structs
 */
class ProfileInfo extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The Profile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProfileType
     */
    public $Profile;
    /**
     * Constructor method for ProfileInfo
     * @uses ProfileInfo::setUniqueID()
     * @uses ProfileInfo::setProfile()
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @param \StructType\ProfileType $profile
     */
    public function __construct(array $uniqueID = array(), \StructType\ProfileType $profile = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setProfile($profile);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileInfoUniqueIDItem) {
            // validation for constraint: itemType
            if (!$profileInfoUniqueIDItem instanceof \StructType\UniqueID_Type) {
                $invalidValues[] = is_object($profileInfoUniqueIDItem) ? get_class($profileInfoUniqueIDItem) : sprintf('%s(%s)', gettype($profileInfoUniqueIDItem), var_export($profileInfoUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @return \StructType\ProfileInfo
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\ProfileInfo
     */
    public function addToUniqueID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get Profile value
     * @return \StructType\ProfileType|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @param \StructType\ProfileType $profile
     * @return \StructType\ProfileInfo
     */
    public function setProfile(\StructType\ProfileType $profile = null)
    {
        $this->Profile = $profile;
        return $this;
    }
}
