<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDescriptiveInfoRequestType StructType
 * @subpackage Structs
 */
class HotelDescriptiveInfoRequestType extends AbstractStructBase
{
    /**
     * The HotelInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelInfo
     */
    public $HotelInfo;
    /**
     * The FacilityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FacilityInfo
     */
    public $FacilityInfo;
    /**
     * The AffiliationInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AffiliationInfo
     */
    public $AffiliationInfo;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactInfo
     */
    public $ContactInfo;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for HotelDescriptiveInfoRequestType
     * @uses HotelDescriptiveInfoRequestType::setHotelInfo()
     * @uses HotelDescriptiveInfoRequestType::setFacilityInfo()
     * @uses HotelDescriptiveInfoRequestType::setAffiliationInfo()
     * @uses HotelDescriptiveInfoRequestType::setContactInfo()
     * @uses HotelDescriptiveInfoRequestType::setHotelCode()
     * @uses HotelDescriptiveInfoRequestType::setHotelName()
     * @param \StructType\HotelInfo $hotelInfo
     * @param \StructType\FacilityInfo $facilityInfo
     * @param \StructType\AffiliationInfo $affiliationInfo
     * @param \StructType\ContactInfo $contactInfo
     * @param string $hotelCode
     * @param string $hotelName
     */
    public function __construct(\StructType\HotelInfo $hotelInfo = null, \StructType\FacilityInfo $facilityInfo = null, \StructType\AffiliationInfo $affiliationInfo = null, \StructType\ContactInfo $contactInfo = null, $hotelCode = null, $hotelName = null)
    {
        $this
            ->setHotelInfo($hotelInfo)
            ->setFacilityInfo($facilityInfo)
            ->setAffiliationInfo($affiliationInfo)
            ->setContactInfo($contactInfo)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName);
    }
    /**
     * Get HotelInfo value
     * @return \StructType\HotelInfo|null
     */
    public function getHotelInfo()
    {
        return $this->HotelInfo;
    }
    /**
     * Set HotelInfo value
     * @param \StructType\HotelInfo $hotelInfo
     * @return \StructType\HotelDescriptiveInfoRequestType
     */
    public function setHotelInfo(\StructType\HotelInfo $hotelInfo = null)
    {
        $this->HotelInfo = $hotelInfo;
        return $this;
    }
    /**
     * Get FacilityInfo value
     * @return \StructType\FacilityInfo|null
     */
    public function getFacilityInfo()
    {
        return $this->FacilityInfo;
    }
    /**
     * Set FacilityInfo value
     * @param \StructType\FacilityInfo $facilityInfo
     * @return \StructType\HotelDescriptiveInfoRequestType
     */
    public function setFacilityInfo(\StructType\FacilityInfo $facilityInfo = null)
    {
        $this->FacilityInfo = $facilityInfo;
        return $this;
    }
    /**
     * Get AffiliationInfo value
     * @return \StructType\AffiliationInfo|null
     */
    public function getAffiliationInfo()
    {
        return $this->AffiliationInfo;
    }
    /**
     * Set AffiliationInfo value
     * @param \StructType\AffiliationInfo $affiliationInfo
     * @return \StructType\HotelDescriptiveInfoRequestType
     */
    public function setAffiliationInfo(\StructType\AffiliationInfo $affiliationInfo = null)
    {
        $this->AffiliationInfo = $affiliationInfo;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfo|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\ContactInfo $contactInfo
     * @return \StructType\HotelDescriptiveInfoRequestType
     */
    public function setContactInfo(\StructType\ContactInfo $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelDescriptiveInfoRequestType
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelDescriptiveInfoRequestType
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
}
