<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType_TPA_ExtensionsType StructType
 * @subpackage Structs
 */
class DocumentType_TPA_ExtensionsType extends TPA_ExtensionsType
{
    /**
     * The DocumentImagesId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentImagesId;
    /**
     * The Series
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Series;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The DivisionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DivisionCode;
    /**
     * Constructor method for DocumentType_TPA_ExtensionsType
     * @uses DocumentType_TPA_ExtensionsType::setDocumentImagesId()
     * @uses DocumentType_TPA_ExtensionsType::setSeries()
     * @uses DocumentType_TPA_ExtensionsType::setNumber()
     * @uses DocumentType_TPA_ExtensionsType::setDivisionCode()
     * @param int $documentImagesId
     * @param string $series
     * @param string $number
     * @param string $divisionCode
     */
    public function __construct($documentImagesId = null, $series = null, $number = null, $divisionCode = null)
    {
        $this
            ->setDocumentImagesId($documentImagesId)
            ->setSeries($series)
            ->setNumber($number)
            ->setDivisionCode($divisionCode);
    }
    /**
     * Get DocumentImagesId value
     * @return int
     */
    public function getDocumentImagesId()
    {
        return $this->DocumentImagesId;
    }
    /**
     * Set DocumentImagesId value
     * @param int $documentImagesId
     * @return \StructType\DocumentType_TPA_ExtensionsType
     */
    public function setDocumentImagesId($documentImagesId = null)
    {
        // validation for constraint: int
        if (!is_null($documentImagesId) && !(is_int($documentImagesId) || ctype_digit($documentImagesId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentImagesId, true), gettype($documentImagesId)), __LINE__);
        }
        $this->DocumentImagesId = $documentImagesId;
        return $this;
    }
    /**
     * Get Series value
     * @return string|null
     */
    public function getSeries()
    {
        return $this->Series;
    }
    /**
     * Set Series value
     * @param string $series
     * @return \StructType\DocumentType_TPA_ExtensionsType
     */
    public function setSeries($series = null)
    {
        // validation for constraint: string
        if (!is_null($series) && !is_string($series)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($series, true), gettype($series)), __LINE__);
        }
        $this->Series = $series;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\DocumentType_TPA_ExtensionsType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get DivisionCode value
     * @return string|null
     */
    public function getDivisionCode()
    {
        return $this->DivisionCode;
    }
    /**
     * Set DivisionCode value
     * @param string $divisionCode
     * @return \StructType\DocumentType_TPA_ExtensionsType
     */
    public function setDivisionCode($divisionCode = null)
    {
        // validation for constraint: string
        if (!is_null($divisionCode) && !is_string($divisionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divisionCode, true), gettype($divisionCode)), __LINE__);
        }
        $this->DivisionCode = $divisionCode;
        return $this;
    }
}
