<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType StructType
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The Preferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerPreferenceType
     */
    public $Preferences;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentType[]
     */
    public $Document;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PersonNameType[]
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Email[]
     */
    public $Email;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Address[]
     */
    public $Address;
    /**
     * The CitizenCountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CitizenCountryName[]
     */
    public $CitizenCountryName;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Nation
     * @var string
     */
    public $Nation;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The MailDistributionSubscribed
     * @var bool
     */
    public $MailDistributionSubscribed;
    /**
     * Constructor method for CustomerType
     * @uses CustomerType::setPreferences()
     * @uses CustomerType::setDocument()
     * @uses CustomerType::setPersonName()
     * @uses CustomerType::setTelephone()
     * @uses CustomerType::setEmail()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setCitizenCountryName()
     * @uses CustomerType::setCustLoyalty()
     * @uses CustomerType::setNation()
     * @uses CustomerType::setGender()
     * @uses CustomerType::setBirthDate()
     * @uses CustomerType::setMailDistributionSubscribed()
     * @param \ArrayType\ArrayOfCustomerPreferenceType $preferences
     * @param \StructType\DocumentType[] $document
     * @param \StructType\PersonNameType[] $personName
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\Email[] $email
     * @param \StructType\Address[] $address
     * @param \StructType\CitizenCountryName[] $citizenCountryName
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param string $nation
     * @param string $gender
     * @param string $birthDate
     * @param bool $mailDistributionSubscribed
     */
    public function __construct(\ArrayType\ArrayOfCustomerPreferenceType $preferences = null, array $document = array(), array $personName = array(), array $telephone = array(), array $email = array(), array $address = array(), array $citizenCountryName = array(), array $custLoyalty = array(), $nation = null, $gender = null, $birthDate = null, $mailDistributionSubscribed = null)
    {
        $this
            ->setPreferences($preferences)
            ->setDocument($document)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setCitizenCountryName($citizenCountryName)
            ->setCustLoyalty($custLoyalty)
            ->setNation($nation)
            ->setGender($gender)
            ->setBirthDate($birthDate)
            ->setMailDistributionSubscribed($mailDistributionSubscribed);
    }
    /**
     * Get Preferences value
     * @return \ArrayType\ArrayOfCustomerPreferenceType|null
     */
    public function getPreferences()
    {
        return $this->Preferences;
    }
    /**
     * Set Preferences value
     * @param \ArrayType\ArrayOfCustomerPreferenceType $preferences
     * @return \StructType\CustomerType
     */
    public function setPreferences(\ArrayType\ArrayOfCustomerPreferenceType $preferences = null)
    {
        $this->Preferences = $preferences;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$customerTypeDocumentItem instanceof \StructType\DocumentType) {
                $invalidValues[] = is_object($customerTypeDocumentItem) ? get_class($customerTypeDocumentItem) : sprintf('%s(%s)', gettype($customerTypeDocumentItem), var_export($customerTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \StructType\DocumentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType[] $document
     * @return \StructType\CustomerType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType $item
     * @return \StructType\CustomerType
     */
    public function addToDocument(\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \StructType\DocumentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonNameType[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonNameForArrayConstraintsFromSetPersonName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePersonNameItem) {
            // validation for constraint: itemType
            if (!$customerTypePersonNameItem instanceof \StructType\PersonNameType) {
                $invalidValues[] = is_object($customerTypePersonNameItem) ? get_class($customerTypePersonNameItem) : sprintf('%s(%s)', gettype($customerTypePersonNameItem), var_export($customerTypePersonNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonName property can only contain items of type \StructType\PersonNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType[] $personName
     * @return \StructType\CustomerType
     */
    public function setPersonName(array $personName = array())
    {
        // validation for constraint: array
        if ('' !== ($personNameArrayErrorMessage = self::validatePersonNameForArrayConstraintsFromSetPersonName($personName))) {
            throw new \InvalidArgumentException($personNameArrayErrorMessage, __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType $item
     * @return \StructType\CustomerType
     */
    public function addToPersonName(\StructType\PersonNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonNameType) {
            throw new \InvalidArgumentException(sprintf('The PersonName property can only contain items of type \StructType\PersonNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($customerTypeTelephoneItem) ? get_class($customerTypeTelephoneItem) : sprintf('%s(%s)', gettype($customerTypeTelephoneItem), var_export($customerTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\CustomerType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\CustomerType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmailItem instanceof \StructType\Email) {
                $invalidValues[] = is_object($customerTypeEmailItem) ? get_class($customerTypeEmailItem) : sprintf('%s(%s)', gettype($customerTypeEmailItem), var_export($customerTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email[] $email
     * @return \StructType\CustomerType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email $item
     * @return \StructType\CustomerType
     */
    public function addToEmail(\StructType\Email $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Email) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$customerTypeAddressItem instanceof \StructType\Address) {
                $invalidValues[] = is_object($customerTypeAddressItem) ? get_class($customerTypeAddressItem) : sprintf('%s(%s)', gettype($customerTypeAddressItem), var_export($customerTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address[] $address
     * @return \StructType\CustomerType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address $item
     * @return \StructType\CustomerType
     */
    public function addToAddress(\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \StructType\CitizenCountryName[]|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * This method is responsible for validating the values passed to the setCitizenCountryName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCitizenCountryName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCitizenCountryNameForArrayConstraintsFromSetCitizenCountryName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeCitizenCountryNameItem) {
            // validation for constraint: itemType
            if (!$customerTypeCitizenCountryNameItem instanceof \StructType\CitizenCountryName) {
                $invalidValues[] = is_object($customerTypeCitizenCountryNameItem) ? get_class($customerTypeCitizenCountryNameItem) : sprintf('%s(%s)', gettype($customerTypeCitizenCountryNameItem), var_export($customerTypeCitizenCountryNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CitizenCountryName property can only contain items of type \StructType\CitizenCountryName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \StructType\CitizenCountryName[] $citizenCountryName
     * @return \StructType\CustomerType
     */
    public function setCitizenCountryName(array $citizenCountryName = array())
    {
        // validation for constraint: array
        if ('' !== ($citizenCountryNameArrayErrorMessage = self::validateCitizenCountryNameForArrayConstraintsFromSetCitizenCountryName($citizenCountryName))) {
            throw new \InvalidArgumentException($citizenCountryNameArrayErrorMessage, __LINE__);
        }
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Add item to CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \StructType\CitizenCountryName $item
     * @return \StructType\CustomerType
     */
    public function addToCitizenCountryName(\StructType\CitizenCountryName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CitizenCountryName) {
            throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of type \StructType\CitizenCountryName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CitizenCountryName[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$customerTypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($customerTypeCustLoyaltyItem) ? get_class($customerTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($customerTypeCustLoyaltyItem), var_export($customerTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\CustomerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\CustomerType
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Nation value
     * @return string|null
     */
    public function getNation()
    {
        return $this->Nation;
    }
    /**
     * Set Nation value
     * @param string $nation
     * @return \StructType\CustomerType
     */
    public function setNation($nation = null)
    {
        // validation for constraint: string
        if (!is_null($nation) && !is_string($nation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nation, true), gettype($nation)), __LINE__);
        }
        $this->Nation = $nation;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\CustomerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\CustomerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get MailDistributionSubscribed value
     * @return bool|null
     */
    public function getMailDistributionSubscribed()
    {
        return $this->MailDistributionSubscribed;
    }
    /**
     * Set MailDistributionSubscribed value
     * @param bool $mailDistributionSubscribed
     * @return \StructType\CustomerType
     */
    public function setMailDistributionSubscribed($mailDistributionSubscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailDistributionSubscribed) && !is_bool($mailDistributionSubscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mailDistributionSubscribed, true), gettype($mailDistributionSubscribed)), __LINE__);
        }
        $this->MailDistributionSubscribed = $mailDistributionSubscribed;
        return $this;
    }
}
