<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy StructType
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The CheckInTime
     * @var string
     */
    public $CheckInTime;
    /**
     * The CheckOutTime
     * @var string
     */
    public $CheckOutTime;
    /**
     * Constructor method for Policy
     * @uses Policy::setCheckInTime()
     * @uses Policy::setCheckOutTime()
     * @param string $checkInTime
     * @param string $checkOutTime
     */
    public function __construct($checkInTime = null, $checkOutTime = null)
    {
        $this
            ->setCheckInTime($checkInTime)
            ->setCheckOutTime($checkOutTime);
    }
    /**
     * Get CheckInTime value
     * @return string|null
     */
    public function getCheckInTime()
    {
        return $this->CheckInTime;
    }
    /**
     * Set CheckInTime value
     * @param string $checkInTime
     * @return \StructType\Policy
     */
    public function setCheckInTime($checkInTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkInTime) && !is_string($checkInTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInTime, true), gettype($checkInTime)), __LINE__);
        }
        $this->CheckInTime = $checkInTime;
        return $this;
    }
    /**
     * Get CheckOutTime value
     * @return string|null
     */
    public function getCheckOutTime()
    {
        return $this->CheckOutTime;
    }
    /**
     * Set CheckOutTime value
     * @param string $checkOutTime
     * @return \StructType\Policy
     */
    public function setCheckOutTime($checkOutTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutTime) && !is_string($checkOutTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkOutTime, true), gettype($checkOutTime)), __LINE__);
        }
        $this->CheckOutTime = $checkOutTime;
        return $this;
    }
}
