<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRef StructType
 * @subpackage Structs
 */
class HotelRef extends AbstractStructBase
{
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * The SegmentCategoryCode
     * @var string
     */
    public $SegmentCategoryCode;
    /**
     * The PropertyClassCode
     * @var string
     */
    public $PropertyClassCode;
    /**
     * The ArchitecturalStyleCode
     * @var string
     */
    public $ArchitecturalStyleCode;
    /**
     * The SupplierIntegrationLevel
     * @var int
     */
    public $SupplierIntegrationLevel;
    /**
     * Constructor method for HotelRef
     * @uses HotelRef::setHotelCode()
     * @uses HotelRef::setHotelName()
     * @uses HotelRef::setSegmentCategoryCode()
     * @uses HotelRef::setPropertyClassCode()
     * @uses HotelRef::setArchitecturalStyleCode()
     * @uses HotelRef::setSupplierIntegrationLevel()
     * @param string $hotelCode
     * @param string $hotelName
     * @param string $segmentCategoryCode
     * @param string $propertyClassCode
     * @param string $architecturalStyleCode
     * @param int $supplierIntegrationLevel
     */
    public function __construct($hotelCode = null, $hotelName = null, $segmentCategoryCode = null, $propertyClassCode = null, $architecturalStyleCode = null, $supplierIntegrationLevel = null)
    {
        $this
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName)
            ->setSegmentCategoryCode($segmentCategoryCode)
            ->setPropertyClassCode($propertyClassCode)
            ->setArchitecturalStyleCode($architecturalStyleCode)
            ->setSupplierIntegrationLevel($supplierIntegrationLevel);
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelRef
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelRef
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get SegmentCategoryCode value
     * @return string|null
     */
    public function getSegmentCategoryCode()
    {
        return $this->SegmentCategoryCode;
    }
    /**
     * Set SegmentCategoryCode value
     * @param string $segmentCategoryCode
     * @return \StructType\HotelRef
     */
    public function setSegmentCategoryCode($segmentCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCategoryCode) && !is_string($segmentCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segmentCategoryCode, true), gettype($segmentCategoryCode)), __LINE__);
        }
        $this->SegmentCategoryCode = $segmentCategoryCode;
        return $this;
    }
    /**
     * Get PropertyClassCode value
     * @return string|null
     */
    public function getPropertyClassCode()
    {
        return $this->PropertyClassCode;
    }
    /**
     * Set PropertyClassCode value
     * @param string $propertyClassCode
     * @return \StructType\HotelRef
     */
    public function setPropertyClassCode($propertyClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyClassCode) && !is_string($propertyClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyClassCode, true), gettype($propertyClassCode)), __LINE__);
        }
        $this->PropertyClassCode = $propertyClassCode;
        return $this;
    }
    /**
     * Get ArchitecturalStyleCode value
     * @return string|null
     */
    public function getArchitecturalStyleCode()
    {
        return $this->ArchitecturalStyleCode;
    }
    /**
     * Set ArchitecturalStyleCode value
     * @param string $architecturalStyleCode
     * @return \StructType\HotelRef
     */
    public function setArchitecturalStyleCode($architecturalStyleCode = null)
    {
        // validation for constraint: string
        if (!is_null($architecturalStyleCode) && !is_string($architecturalStyleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($architecturalStyleCode, true), gettype($architecturalStyleCode)), __LINE__);
        }
        $this->ArchitecturalStyleCode = $architecturalStyleCode;
        return $this;
    }
    /**
     * Get SupplierIntegrationLevel value
     * @return int|null
     */
    public function getSupplierIntegrationLevel()
    {
        return $this->SupplierIntegrationLevel;
    }
    /**
     * Set SupplierIntegrationLevel value
     * @param int $supplierIntegrationLevel
     * @return \StructType\HotelRef
     */
    public function setSupplierIntegrationLevel($supplierIntegrationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($supplierIntegrationLevel) && !(is_int($supplierIntegrationLevel) || ctype_digit($supplierIntegrationLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplierIntegrationLevel, true), gettype($supplierIntegrationLevel)), __LINE__);
        }
        $this->SupplierIntegrationLevel = $supplierIntegrationLevel;
        return $this;
    }
}
