<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionType StructType
 * @subpackage Structs
 */
class CommissionType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The CommissionableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommissionableAmount
     */
    public $CommissionableAmount;
    /**
     * The PrepaidAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrepaidAmount
     */
    public $PrepaidAmount;
    /**
     * The FlatCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FlatCommission
     */
    public $FlatCommission;
    /**
     * The CommissionPayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommissionPayableAmount
     */
    public $CommissionPayableAmount;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $Comment;
    /**
     * The StatusType
     * @var string
     */
    public $StatusType;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The ReasonCode
     * @var string
     */
    public $ReasonCode;
    /**
     * The BillToID
     * @var string
     */
    public $BillToID;
    /**
     * The Frequency
     * @var string
     */
    public $Frequency;
    /**
     * The MaxCommissionUnitApplies
     * @var int
     */
    public $MaxCommissionUnitApplies;
    /**
     * The CapAmount
     * @var float
     */
    public $CapAmount;
    /**
     * Constructor method for CommissionType
     * @uses CommissionType::setUniqueID()
     * @uses CommissionType::setCommissionableAmount()
     * @uses CommissionType::setPrepaidAmount()
     * @uses CommissionType::setFlatCommission()
     * @uses CommissionType::setCommissionPayableAmount()
     * @uses CommissionType::setComment()
     * @uses CommissionType::setStatusType()
     * @uses CommissionType::setPercent()
     * @uses CommissionType::setCurrencyCode()
     * @uses CommissionType::setDecimalPlaces()
     * @uses CommissionType::setReasonCode()
     * @uses CommissionType::setBillToID()
     * @uses CommissionType::setFrequency()
     * @uses CommissionType::setMaxCommissionUnitApplies()
     * @uses CommissionType::setCapAmount()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\CommissionableAmount $commissionableAmount
     * @param \StructType\PrepaidAmount $prepaidAmount
     * @param \StructType\FlatCommission $flatCommission
     * @param \StructType\CommissionPayableAmount $commissionPayableAmount
     * @param \StructType\ParagraphType $comment
     * @param string $statusType
     * @param float $percent
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $reasonCode
     * @param string $billToID
     * @param string $frequency
     * @param int $maxCommissionUnitApplies
     * @param float $capAmount
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\CommissionableAmount $commissionableAmount = null, \StructType\PrepaidAmount $prepaidAmount = null, \StructType\FlatCommission $flatCommission = null, \StructType\CommissionPayableAmount $commissionPayableAmount = null, \StructType\ParagraphType $comment = null, $statusType = null, $percent = null, $currencyCode = null, $decimalPlaces = null, $reasonCode = null, $billToID = null, $frequency = null, $maxCommissionUnitApplies = null, $capAmount = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setCommissionableAmount($commissionableAmount)
            ->setPrepaidAmount($prepaidAmount)
            ->setFlatCommission($flatCommission)
            ->setCommissionPayableAmount($commissionPayableAmount)
            ->setComment($comment)
            ->setStatusType($statusType)
            ->setPercent($percent)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setReasonCode($reasonCode)
            ->setBillToID($billToID)
            ->setFrequency($frequency)
            ->setMaxCommissionUnitApplies($maxCommissionUnitApplies)
            ->setCapAmount($capAmount);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\CommissionType
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get CommissionableAmount value
     * @return \StructType\CommissionableAmount|null
     */
    public function getCommissionableAmount()
    {
        return $this->CommissionableAmount;
    }
    /**
     * Set CommissionableAmount value
     * @param \StructType\CommissionableAmount $commissionableAmount
     * @return \StructType\CommissionType
     */
    public function setCommissionableAmount(\StructType\CommissionableAmount $commissionableAmount = null)
    {
        $this->CommissionableAmount = $commissionableAmount;
        return $this;
    }
    /**
     * Get PrepaidAmount value
     * @return \StructType\PrepaidAmount|null
     */
    public function getPrepaidAmount()
    {
        return $this->PrepaidAmount;
    }
    /**
     * Set PrepaidAmount value
     * @param \StructType\PrepaidAmount $prepaidAmount
     * @return \StructType\CommissionType
     */
    public function setPrepaidAmount(\StructType\PrepaidAmount $prepaidAmount = null)
    {
        $this->PrepaidAmount = $prepaidAmount;
        return $this;
    }
    /**
     * Get FlatCommission value
     * @return \StructType\FlatCommission|null
     */
    public function getFlatCommission()
    {
        return $this->FlatCommission;
    }
    /**
     * Set FlatCommission value
     * @param \StructType\FlatCommission $flatCommission
     * @return \StructType\CommissionType
     */
    public function setFlatCommission(\StructType\FlatCommission $flatCommission = null)
    {
        $this->FlatCommission = $flatCommission;
        return $this;
    }
    /**
     * Get CommissionPayableAmount value
     * @return \StructType\CommissionPayableAmount|null
     */
    public function getCommissionPayableAmount()
    {
        return $this->CommissionPayableAmount;
    }
    /**
     * Set CommissionPayableAmount value
     * @param \StructType\CommissionPayableAmount $commissionPayableAmount
     * @return \StructType\CommissionType
     */
    public function setCommissionPayableAmount(\StructType\CommissionPayableAmount $commissionPayableAmount = null)
    {
        $this->CommissionPayableAmount = $commissionPayableAmount;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\ParagraphType|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param \StructType\ParagraphType $comment
     * @return \StructType\CommissionType
     */
    public function setComment(\StructType\ParagraphType $comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get StatusType value
     * @return string|null
     */
    public function getStatusType()
    {
        return $this->StatusType;
    }
    /**
     * Set StatusType value
     * @param string $statusType
     * @return \StructType\CommissionType
     */
    public function setStatusType($statusType = null)
    {
        // validation for constraint: string
        if (!is_null($statusType) && !is_string($statusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusType, true), gettype($statusType)), __LINE__);
        }
        $this->StatusType = $statusType;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\CommissionType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CommissionType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\CommissionType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\CommissionType
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get BillToID value
     * @return string|null
     */
    public function getBillToID()
    {
        return $this->BillToID;
    }
    /**
     * Set BillToID value
     * @param string $billToID
     * @return \StructType\CommissionType
     */
    public function setBillToID($billToID = null)
    {
        // validation for constraint: string
        if (!is_null($billToID) && !is_string($billToID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billToID, true), gettype($billToID)), __LINE__);
        }
        $this->BillToID = $billToID;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \StructType\CommissionType
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get MaxCommissionUnitApplies value
     * @return int|null
     */
    public function getMaxCommissionUnitApplies()
    {
        return $this->MaxCommissionUnitApplies;
    }
    /**
     * Set MaxCommissionUnitApplies value
     * @param int $maxCommissionUnitApplies
     * @return \StructType\CommissionType
     */
    public function setMaxCommissionUnitApplies($maxCommissionUnitApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxCommissionUnitApplies) && !(is_int($maxCommissionUnitApplies) || ctype_digit($maxCommissionUnitApplies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCommissionUnitApplies, true), gettype($maxCommissionUnitApplies)), __LINE__);
        }
        $this->MaxCommissionUnitApplies = $maxCommissionUnitApplies;
        return $this;
    }
    /**
     * Get CapAmount value
     * @return float|null
     */
    public function getCapAmount()
    {
        return $this->CapAmount;
    }
    /**
     * Set CapAmount value
     * @param float $capAmount
     * @return \StructType\CommissionType
     */
    public function setCapAmount($capAmount = null)
    {
        // validation for constraint: float
        if (!is_null($capAmount) && !(is_float($capAmount) || is_numeric($capAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capAmount, true), gettype($capAmount)), __LINE__);
        }
        $this->CapAmount = $capAmount;
        return $this;
    }
}
