<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextDescriptionType StructType
 * @subpackage Structs
 */
class TextDescriptionType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - choice: Description | URL
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Description
     */
    public $Description;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - choice: Description | URL
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for TextDescriptionType
     * @uses TextDescriptionType::setDescription()
     * @uses TextDescriptionType::setURL()
     * @uses TextDescriptionType::setCategory()
     * @uses TextDescriptionType::setLanguage()
     * @param \StructType\Description $description
     * @param string $uRL
     * @param string $category
     * @param string $language
     */
    public function __construct(\StructType\Description $description = null, $uRL = null, $category = null, $language = null)
    {
        $this
            ->setDescription($description)
            ->setURL($uRL)
            ->setCategory($category)
            ->setLanguage($language);
    }
    /**
     * Get Description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDescriptionForChoiceConstraintsFromSetDescription($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Description can\'t be set as the property %s is already set. Only one property must be set among these properties: Description, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Description value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Description $description
     * @return \StructType\TextDescriptionType
     */
    public function setDescription(\StructType\Description $description = null)
    {
        // validation for constraint: choice(Description, URL)
        if ('' !== ($descriptionChoiceErrorMessage = self::validateDescriptionForChoiceConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateURLForChoiceConstraintsFromSetURL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Description',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property URL can\'t be set as the property %s is already set. Only one property must be set among these properties: URL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set URL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uRL
     * @return \StructType\TextDescriptionType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        // validation for constraint: choice(Description, URL)
        if ('' !== ($uRLChoiceErrorMessage = self::validateURLForChoiceConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLChoiceErrorMessage, __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\TextDescriptionType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\TextDescriptionType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
}
