<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * @subpackage Structs
 */
class Voucher extends AbstractStructBase
{
    /**
     * The SeriesCode
     * @var string
     */
    public $SeriesCode;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The BillingNumber
     * @var string
     */
    public $BillingNumber;
    /**
     * The SupplierIdentifier
     * @var string
     */
    public $SupplierIdentifier;
    /**
     * The Identifier
     * @var string
     */
    public $Identifier;
    /**
     * The ValueType
     * @var string
     */
    public $ValueType;
    /**
     * The ElectronicIndicator
     * @var bool
     */
    public $ElectronicIndicator;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setSeriesCode()
     * @uses Voucher::setEffectiveDate()
     * @uses Voucher::setExpireDate()
     * @uses Voucher::setExpireDateExclusiveIndicator()
     * @uses Voucher::setBillingNumber()
     * @uses Voucher::setSupplierIdentifier()
     * @uses Voucher::setIdentifier()
     * @uses Voucher::setValueType()
     * @uses Voucher::setElectronicIndicator()
     * @param string $seriesCode
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $billingNumber
     * @param string $supplierIdentifier
     * @param string $identifier
     * @param string $valueType
     * @param bool $electronicIndicator
     */
    public function __construct($seriesCode = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $billingNumber = null, $supplierIdentifier = null, $identifier = null, $valueType = null, $electronicIndicator = null)
    {
        $this
            ->setSeriesCode($seriesCode)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setBillingNumber($billingNumber)
            ->setSupplierIdentifier($supplierIdentifier)
            ->setIdentifier($identifier)
            ->setValueType($valueType)
            ->setElectronicIndicator($electronicIndicator);
    }
    /**
     * Get SeriesCode value
     * @return string|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param string $seriesCode
     * @return \StructType\Voucher
     */
    public function setSeriesCode($seriesCode = null)
    {
        // validation for constraint: string
        if (!is_null($seriesCode) && !is_string($seriesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesCode, true), gettype($seriesCode)), __LINE__);
        }
        $this->SeriesCode = $seriesCode;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Voucher
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Voucher
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\Voucher
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get BillingNumber value
     * @return string|null
     */
    public function getBillingNumber()
    {
        return $this->BillingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \StructType\Voucher
     */
    public function setBillingNumber($billingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingNumber) && !is_string($billingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingNumber, true), gettype($billingNumber)), __LINE__);
        }
        $this->BillingNumber = $billingNumber;
        return $this;
    }
    /**
     * Get SupplierIdentifier value
     * @return string|null
     */
    public function getSupplierIdentifier()
    {
        return $this->SupplierIdentifier;
    }
    /**
     * Set SupplierIdentifier value
     * @param string $supplierIdentifier
     * @return \StructType\Voucher
     */
    public function setSupplierIdentifier($supplierIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplierIdentifier) && !is_string($supplierIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierIdentifier, true), gettype($supplierIdentifier)), __LINE__);
        }
        $this->SupplierIdentifier = $supplierIdentifier;
        return $this;
    }
    /**
     * Get Identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param string $identifier
     * @return \StructType\Voucher
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @param string $valueType
     * @return \StructType\Voucher
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: string
        if (!is_null($valueType) && !is_string($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueType, true), gettype($valueType)), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Get ElectronicIndicator value
     * @return bool|null
     */
    public function getElectronicIndicator()
    {
        return $this->ElectronicIndicator;
    }
    /**
     * Set ElectronicIndicator value
     * @param bool $electronicIndicator
     * @return \StructType\Voucher
     */
    public function setElectronicIndicator($electronicIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronicIndicator) && !is_bool($electronicIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($electronicIndicator, true), gettype($electronicIndicator)), __LINE__);
        }
        $this->ElectronicIndicator = $electronicIndicator;
        return $this;
    }
}
