<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectionCriteria StructType
 * @subpackage Structs
 */
class SelectionCriteria extends AbstractStructBase
{
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The DateType
     * @var string
     */
    public $DateType;
    /**
     * The SelectionType
     * @var string
     */
    public $SelectionType;
    /**
     * The GroupCode
     * @var string
     */
    public $GroupCode;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * Constructor method for SelectionCriteria
     * @uses SelectionCriteria::setStart()
     * @uses SelectionCriteria::setDuration()
     * @uses SelectionCriteria::setEnd()
     * @uses SelectionCriteria::setDateType()
     * @uses SelectionCriteria::setSelectionType()
     * @uses SelectionCriteria::setGroupCode()
     * @uses SelectionCriteria::setResStatus()
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $dateType
     * @param string $selectionType
     * @param string $groupCode
     * @param string $resStatus
     */
    public function __construct($start = null, $duration = null, $end = null, $dateType = null, $selectionType = null, $groupCode = null, $resStatus = null)
    {
        $this
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setDateType($dateType)
            ->setSelectionType($selectionType)
            ->setGroupCode($groupCode)
            ->setResStatus($resStatus);
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\SelectionCriteria
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\SelectionCriteria
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\SelectionCriteria
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get DateType value
     * @return string|null
     */
    public function getDateType()
    {
        return $this->DateType;
    }
    /**
     * Set DateType value
     * @param string $dateType
     * @return \StructType\SelectionCriteria
     */
    public function setDateType($dateType = null)
    {
        // validation for constraint: string
        if (!is_null($dateType) && !is_string($dateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateType, true), gettype($dateType)), __LINE__);
        }
        $this->DateType = $dateType;
        return $this;
    }
    /**
     * Get SelectionType value
     * @return string|null
     */
    public function getSelectionType()
    {
        return $this->SelectionType;
    }
    /**
     * Set SelectionType value
     * @param string $selectionType
     * @return \StructType\SelectionCriteria
     */
    public function setSelectionType($selectionType = null)
    {
        // validation for constraint: string
        if (!is_null($selectionType) && !is_string($selectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectionType, true), gettype($selectionType)), __LINE__);
        }
        $this->SelectionType = $selectionType;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\SelectionCriteria
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @param string $resStatus
     * @return \StructType\SelectionCriteria
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: string
        if (!is_null($resStatus) && !is_string($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resStatus, true), gettype($resStatus)), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
}
