<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanCandidate StructType
 * @subpackage Structs
 */
class RatePlanCandidate extends AbstractStructBase
{
    /**
     * The HotelRefs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef
     */
    public $HotelRefs;
    /**
     * The MealsIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MealsIncluded
     */
    public $MealsIncluded;
    /**
     * The ArrivalPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ArrivalPolicy
     */
    public $ArrivalPolicy;
    /**
     * The RatePlanCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RatePlanCommission
     */
    public $RatePlanCommission;
    /**
     * The RatePlanType
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanQualifier
     * @var bool
     */
    public $RatePlanQualifier;
    /**
     * The RatePlanCategory
     * @var string
     */
    public $RatePlanCategory;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The PrepaidQualifier
     * @var string
     */
    public $PrepaidQualifier;
    /**
     * The AvailRatesOnlyInd
     * @var bool
     */
    public $AvailRatesOnlyInd;
    /**
     * The RatePlanFilterCode
     * @var string
     */
    public $RatePlanFilterCode;
    /**
     * Constructor method for RatePlanCandidate
     * @uses RatePlanCandidate::setHotelRefs()
     * @uses RatePlanCandidate::setMealsIncluded()
     * @uses RatePlanCandidate::setArrivalPolicy()
     * @uses RatePlanCandidate::setRatePlanCommission()
     * @uses RatePlanCandidate::setRatePlanType()
     * @uses RatePlanCandidate::setRatePlanCode()
     * @uses RatePlanCandidate::setRatePlanID()
     * @uses RatePlanCandidate::setRatePlanQualifier()
     * @uses RatePlanCandidate::setRatePlanCategory()
     * @uses RatePlanCandidate::setRPH()
     * @uses RatePlanCandidate::setPrepaidQualifier()
     * @uses RatePlanCandidate::setAvailRatesOnlyInd()
     * @uses RatePlanCandidate::setRatePlanFilterCode()
     * @param \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef $hotelRefs
     * @param \StructType\MealsIncluded $mealsIncluded
     * @param \StructType\ArrivalPolicy $arrivalPolicy
     * @param \StructType\RatePlanCommission $ratePlanCommission
     * @param string $ratePlanType
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param bool $ratePlanQualifier
     * @param string $ratePlanCategory
     * @param string $rPH
     * @param string $prepaidQualifier
     * @param bool $availRatesOnlyInd
     * @param string $ratePlanFilterCode
     */
    public function __construct(\ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef $hotelRefs = null, \StructType\MealsIncluded $mealsIncluded = null, \StructType\ArrivalPolicy $arrivalPolicy = null, \StructType\RatePlanCommission $ratePlanCommission = null, $ratePlanType = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanQualifier = null, $ratePlanCategory = null, $rPH = null, $prepaidQualifier = null, $availRatesOnlyInd = null, $ratePlanFilterCode = null)
    {
        $this
            ->setHotelRefs($hotelRefs)
            ->setMealsIncluded($mealsIncluded)
            ->setArrivalPolicy($arrivalPolicy)
            ->setRatePlanCommission($ratePlanCommission)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanQualifier($ratePlanQualifier)
            ->setRatePlanCategory($ratePlanCategory)
            ->setRPH($rPH)
            ->setPrepaidQualifier($prepaidQualifier)
            ->setAvailRatesOnlyInd($availRatesOnlyInd)
            ->setRatePlanFilterCode($ratePlanFilterCode);
    }
    /**
     * Get HotelRefs value
     * @return \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef|null
     */
    public function getHotelRefs()
    {
        return $this->HotelRefs;
    }
    /**
     * Set HotelRefs value
     * @param \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef $hotelRefs
     * @return \StructType\RatePlanCandidate
     */
    public function setHotelRefs(\ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef $hotelRefs = null)
    {
        $this->HotelRefs = $hotelRefs;
        return $this;
    }
    /**
     * Get MealsIncluded value
     * @return \StructType\MealsIncluded|null
     */
    public function getMealsIncluded()
    {
        return $this->MealsIncluded;
    }
    /**
     * Set MealsIncluded value
     * @param \StructType\MealsIncluded $mealsIncluded
     * @return \StructType\RatePlanCandidate
     */
    public function setMealsIncluded(\StructType\MealsIncluded $mealsIncluded = null)
    {
        $this->MealsIncluded = $mealsIncluded;
        return $this;
    }
    /**
     * Get ArrivalPolicy value
     * @return \StructType\ArrivalPolicy|null
     */
    public function getArrivalPolicy()
    {
        return $this->ArrivalPolicy;
    }
    /**
     * Set ArrivalPolicy value
     * @param \StructType\ArrivalPolicy $arrivalPolicy
     * @return \StructType\RatePlanCandidate
     */
    public function setArrivalPolicy(\StructType\ArrivalPolicy $arrivalPolicy = null)
    {
        $this->ArrivalPolicy = $arrivalPolicy;
        return $this;
    }
    /**
     * Get RatePlanCommission value
     * @return \StructType\RatePlanCommission|null
     */
    public function getRatePlanCommission()
    {
        return $this->RatePlanCommission;
    }
    /**
     * Set RatePlanCommission value
     * @param \StructType\RatePlanCommission $ratePlanCommission
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanCommission(\StructType\RatePlanCommission $ratePlanCommission = null)
    {
        $this->RatePlanCommission = $ratePlanCommission;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanQualifier value
     * @return bool|null
     */
    public function getRatePlanQualifier()
    {
        return $this->RatePlanQualifier;
    }
    /**
     * Set RatePlanQualifier value
     * @param bool $ratePlanQualifier
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanQualifier($ratePlanQualifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($ratePlanQualifier) && !is_bool($ratePlanQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ratePlanQualifier, true), gettype($ratePlanQualifier)), __LINE__);
        }
        $this->RatePlanQualifier = $ratePlanQualifier;
        return $this;
    }
    /**
     * Get RatePlanCategory value
     * @return string|null
     */
    public function getRatePlanCategory()
    {
        return $this->RatePlanCategory;
    }
    /**
     * Set RatePlanCategory value
     * @param string $ratePlanCategory
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanCategory($ratePlanCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCategory) && !is_string($ratePlanCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCategory, true), gettype($ratePlanCategory)), __LINE__);
        }
        $this->RatePlanCategory = $ratePlanCategory;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\RatePlanCandidate
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PrepaidQualifier value
     * @return string|null
     */
    public function getPrepaidQualifier()
    {
        return $this->PrepaidQualifier;
    }
    /**
     * Set PrepaidQualifier value
     * @param string $prepaidQualifier
     * @return \StructType\RatePlanCandidate
     */
    public function setPrepaidQualifier($prepaidQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($prepaidQualifier) && !is_string($prepaidQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaidQualifier, true), gettype($prepaidQualifier)), __LINE__);
        }
        $this->PrepaidQualifier = $prepaidQualifier;
        return $this;
    }
    /**
     * Get AvailRatesOnlyInd value
     * @return bool|null
     */
    public function getAvailRatesOnlyInd()
    {
        return $this->AvailRatesOnlyInd;
    }
    /**
     * Set AvailRatesOnlyInd value
     * @param bool $availRatesOnlyInd
     * @return \StructType\RatePlanCandidate
     */
    public function setAvailRatesOnlyInd($availRatesOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($availRatesOnlyInd) && !is_bool($availRatesOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availRatesOnlyInd, true), gettype($availRatesOnlyInd)), __LINE__);
        }
        $this->AvailRatesOnlyInd = $availRatesOnlyInd;
        return $this;
    }
    /**
     * Get RatePlanFilterCode value
     * @return string|null
     */
    public function getRatePlanFilterCode()
    {
        return $this->RatePlanFilterCode;
    }
    /**
     * Set RatePlanFilterCode value
     * @param string $ratePlanFilterCode
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanFilterCode($ratePlanFilterCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanFilterCode) && !is_string($ratePlanFilterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanFilterCode, true), gettype($ratePlanFilterCode)), __LINE__);
        }
        $this->RatePlanFilterCode = $ratePlanFilterCode;
        return $this;
    }
}
