<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Offers StructType
 * @subpackage Structs
 */
class Offers extends AbstractStructBase
{
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Offer[]
     */
    public $Offer;
    /**
     * The SendData
     * @var bool
     */
    public $SendData;
    /**
     * Constructor method for Offers
     * @uses Offers::setOffer()
     * @uses Offers::setSendData()
     * @param \StructType\Offer[] $offer
     * @param bool $sendData
     */
    public function __construct(array $offer = array(), $sendData = null)
    {
        $this
            ->setOffer($offer)
            ->setSendData($sendData);
    }
    /**
     * Get Offer value
     * @return \StructType\Offer[]|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offersOfferItem) {
            // validation for constraint: itemType
            if (!$offersOfferItem instanceof \StructType\Offer) {
                $invalidValues[] = is_object($offersOfferItem) ? get_class($offersOfferItem) : sprintf('%s(%s)', gettype($offersOfferItem), var_export($offersOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\Offer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\Offer[] $offer
     * @return \StructType\Offers
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\Offer $item
     * @return \StructType\Offers
     */
    public function addToOffer(\StructType\Offer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Offer) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\Offer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
    /**
     * Get SendData value
     * @return bool|null
     */
    public function getSendData()
    {
        return $this->SendData;
    }
    /**
     * Set SendData value
     * @param bool $sendData
     * @return \StructType\Offers
     */
    public function setSendData($sendData = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendData) && !is_bool($sendData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendData, true), gettype($sendData)), __LINE__);
        }
        $this->SendData = $sendData;
        return $this;
    }
}
