<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryCrossRef StructType
 * @subpackage Structs
 */
class InventoryCrossRef extends AbstractStructBase
{
    /**
     * The RequestInvCode
     * @var string
     */
    public $RequestInvCode;
    /**
     * The RequestInvGroupingCode
     * @var string
     */
    public $RequestInvGroupingCode;
    /**
     * The ResponseInvCode
     * @var string
     */
    public $ResponseInvCode;
    /**
     * The ResponseInvGroupingCode
     * @var string
     */
    public $ResponseInvGroupingCode;
    /**
     * Constructor method for InventoryCrossRef
     * @uses InventoryCrossRef::setRequestInvCode()
     * @uses InventoryCrossRef::setRequestInvGroupingCode()
     * @uses InventoryCrossRef::setResponseInvCode()
     * @uses InventoryCrossRef::setResponseInvGroupingCode()
     * @param string $requestInvCode
     * @param string $requestInvGroupingCode
     * @param string $responseInvCode
     * @param string $responseInvGroupingCode
     */
    public function __construct($requestInvCode = null, $requestInvGroupingCode = null, $responseInvCode = null, $responseInvGroupingCode = null)
    {
        $this
            ->setRequestInvCode($requestInvCode)
            ->setRequestInvGroupingCode($requestInvGroupingCode)
            ->setResponseInvCode($responseInvCode)
            ->setResponseInvGroupingCode($responseInvGroupingCode);
    }
    /**
     * Get RequestInvCode value
     * @return string|null
     */
    public function getRequestInvCode()
    {
        return $this->RequestInvCode;
    }
    /**
     * Set RequestInvCode value
     * @param string $requestInvCode
     * @return \StructType\InventoryCrossRef
     */
    public function setRequestInvCode($requestInvCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestInvCode) && !is_string($requestInvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestInvCode, true), gettype($requestInvCode)), __LINE__);
        }
        $this->RequestInvCode = $requestInvCode;
        return $this;
    }
    /**
     * Get RequestInvGroupingCode value
     * @return string|null
     */
    public function getRequestInvGroupingCode()
    {
        return $this->RequestInvGroupingCode;
    }
    /**
     * Set RequestInvGroupingCode value
     * @param string $requestInvGroupingCode
     * @return \StructType\InventoryCrossRef
     */
    public function setRequestInvGroupingCode($requestInvGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestInvGroupingCode) && !is_string($requestInvGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestInvGroupingCode, true), gettype($requestInvGroupingCode)), __LINE__);
        }
        $this->RequestInvGroupingCode = $requestInvGroupingCode;
        return $this;
    }
    /**
     * Get ResponseInvCode value
     * @return string|null
     */
    public function getResponseInvCode()
    {
        return $this->ResponseInvCode;
    }
    /**
     * Set ResponseInvCode value
     * @param string $responseInvCode
     * @return \StructType\InventoryCrossRef
     */
    public function setResponseInvCode($responseInvCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseInvCode) && !is_string($responseInvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseInvCode, true), gettype($responseInvCode)), __LINE__);
        }
        $this->ResponseInvCode = $responseInvCode;
        return $this;
    }
    /**
     * Get ResponseInvGroupingCode value
     * @return string|null
     */
    public function getResponseInvGroupingCode()
    {
        return $this->ResponseInvGroupingCode;
    }
    /**
     * Set ResponseInvGroupingCode value
     * @param string $responseInvGroupingCode
     * @return \StructType\InventoryCrossRef
     */
    public function setResponseInvGroupingCode($responseInvGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseInvGroupingCode) && !is_string($responseInvGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseInvGroupingCode, true), gettype($responseInvGroupingCode)), __LINE__);
        }
        $this->ResponseInvGroupingCode = $responseInvGroupingCode;
        return $this;
    }
}
