<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestRoomType StructType
 * @subpackage Structs
 */
class GuestRoomType extends AbstractStructBase
{
    /**
     * The Quantities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Quantities
     */
    public $Quantities;
    /**
     * The Occupancy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Occupancy[]
     */
    public $Occupancy;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Room
     */
    public $Room;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $Description;
    /**
     * Constructor method for GuestRoomType
     * @uses GuestRoomType::setQuantities()
     * @uses GuestRoomType::setOccupancy()
     * @uses GuestRoomType::setRoom()
     * @uses GuestRoomType::setDescription()
     * @param \StructType\Quantities $quantities
     * @param \StructType\Occupancy[] $occupancy
     * @param \StructType\Room $room
     * @param \StructType\ParagraphType $description
     */
    public function __construct(\StructType\Quantities $quantities = null, array $occupancy = array(), \StructType\Room $room = null, \StructType\ParagraphType $description = null)
    {
        $this
            ->setQuantities($quantities)
            ->setOccupancy($occupancy)
            ->setRoom($room)
            ->setDescription($description);
    }
    /**
     * Get Quantities value
     * @return \StructType\Quantities|null
     */
    public function getQuantities()
    {
        return $this->Quantities;
    }
    /**
     * Set Quantities value
     * @param \StructType\Quantities $quantities
     * @return \StructType\GuestRoomType
     */
    public function setQuantities(\StructType\Quantities $quantities = null)
    {
        $this->Quantities = $quantities;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return \StructType\Occupancy[]|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * This method is responsible for validating the values passed to the setOccupancy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOccupancy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOccupancyForArrayConstraintsFromSetOccupancy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestRoomTypeOccupancyItem) {
            // validation for constraint: itemType
            if (!$guestRoomTypeOccupancyItem instanceof \StructType\Occupancy) {
                $invalidValues[] = is_object($guestRoomTypeOccupancyItem) ? get_class($guestRoomTypeOccupancyItem) : sprintf('%s(%s)', gettype($guestRoomTypeOccupancyItem), var_export($guestRoomTypeOccupancyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy[] $occupancy
     * @return \StructType\GuestRoomType
     */
    public function setOccupancy(array $occupancy = array())
    {
        // validation for constraint: array
        if ('' !== ($occupancyArrayErrorMessage = self::validateOccupancyForArrayConstraintsFromSetOccupancy($occupancy))) {
            throw new \InvalidArgumentException($occupancyArrayErrorMessage, __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Add item to Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy $item
     * @return \StructType\GuestRoomType
     */
    public function addToOccupancy(\StructType\Occupancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Occupancy) {
            throw new \InvalidArgumentException(sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Occupancy[] = $item;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \StructType\Room $room
     * @return \StructType\GuestRoomType
     */
    public function setRoom(\StructType\Room $room = null)
    {
        $this->Room = $room;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\ParagraphType $description
     * @return \StructType\GuestRoomType
     */
    public function setDescription(\StructType\ParagraphType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
}
