<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomAmenityPrefType ArrayType
 * @subpackage Arrays
 */
class ArrayOfRoomAmenityPrefType extends AbstractStructArrayBase
{
    /**
     * The Amenity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomAmenityPrefType[]
     */
    public $Amenity;
    /**
     * Constructor method for ArrayOfRoomAmenityPrefType
     * @uses ArrayOfRoomAmenityPrefType::setAmenity()
     * @param \StructType\RoomAmenityPrefType[] $amenity
     */
    public function __construct(array $amenity = array())
    {
        $this
            ->setAmenity($amenity);
    }
    /**
     * Get Amenity value
     * @return \StructType\RoomAmenityPrefType[]|null
     */
    public function getAmenity()
    {
        return $this->Amenity;
    }
    /**
     * This method is responsible for validating the values passed to the setAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmenityForArrayConstraintsFromSetAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRoomAmenityPrefTypeAmenityItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomAmenityPrefTypeAmenityItem instanceof \StructType\RoomAmenityPrefType) {
                $invalidValues[] = is_object($arrayOfRoomAmenityPrefTypeAmenityItem) ? get_class($arrayOfRoomAmenityPrefTypeAmenityItem) : sprintf('%s(%s)', gettype($arrayOfRoomAmenityPrefTypeAmenityItem), var_export($arrayOfRoomAmenityPrefTypeAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Amenity property can only contain items of type \StructType\RoomAmenityPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Amenity value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomAmenityPrefType[] $amenity
     * @return \ArrayType\ArrayOfRoomAmenityPrefType
     */
    public function setAmenity(array $amenity = array())
    {
        // validation for constraint: array
        if ('' !== ($amenityArrayErrorMessage = self::validateAmenityForArrayConstraintsFromSetAmenity($amenity))) {
            throw new \InvalidArgumentException($amenityArrayErrorMessage, __LINE__);
        }
        $this->Amenity = $amenity;
        return $this;
    }
    /**
     * Add item to Amenity value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomAmenityPrefType $item
     * @return \ArrayType\ArrayOfRoomAmenityPrefType
     */
    public function addToAmenity(\StructType\RoomAmenityPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomAmenityPrefType) {
            throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of type \StructType\RoomAmenityPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Amenity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoomAmenityPrefType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoomAmenityPrefType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoomAmenityPrefType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoomAmenityPrefType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoomAmenityPrefType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Amenity
     */
    public function getAttributeName()
    {
        return 'Amenity';
    }
}
