<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerPreferenceType ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerPreferenceType extends AbstractStructArrayBase
{
    /**
     * The Preference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerPreferenceType[]
     */
    public $Preference;
    /**
     * Constructor method for ArrayOfCustomerPreferenceType
     * @uses ArrayOfCustomerPreferenceType::setPreference()
     * @param \StructType\CustomerPreferenceType[] $preference
     */
    public function __construct(array $preference = array())
    {
        $this
            ->setPreference($preference);
    }
    /**
     * Get Preference value
     * @return \StructType\CustomerPreferenceType[]|null
     */
    public function getPreference()
    {
        return $this->Preference;
    }
    /**
     * This method is responsible for validating the values passed to the setPreference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreferenceForArrayConstraintsFromSetPreference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerPreferenceTypePreferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerPreferenceTypePreferenceItem instanceof \StructType\CustomerPreferenceType) {
                $invalidValues[] = is_object($arrayOfCustomerPreferenceTypePreferenceItem) ? get_class($arrayOfCustomerPreferenceTypePreferenceItem) : sprintf('%s(%s)', gettype($arrayOfCustomerPreferenceTypePreferenceItem), var_export($arrayOfCustomerPreferenceTypePreferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Preference property can only contain items of type \StructType\CustomerPreferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Preference value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPreferenceType[] $preference
     * @return \ArrayType\ArrayOfCustomerPreferenceType
     */
    public function setPreference(array $preference = array())
    {
        // validation for constraint: array
        if ('' !== ($preferenceArrayErrorMessage = self::validatePreferenceForArrayConstraintsFromSetPreference($preference))) {
            throw new \InvalidArgumentException($preferenceArrayErrorMessage, __LINE__);
        }
        $this->Preference = $preference;
        return $this;
    }
    /**
     * Add item to Preference value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPreferenceType $item
     * @return \ArrayType\ArrayOfCustomerPreferenceType
     */
    public function addToPreference(\StructType\CustomerPreferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerPreferenceType) {
            throw new \InvalidArgumentException(sprintf('The Preference property can only contain items of type \StructType\CustomerPreferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Preference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerPreferenceType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerPreferenceType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerPreferenceType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerPreferenceType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerPreferenceType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Preference
     */
    public function getAttributeName()
    {
        return 'Preference';
    }
}
