<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlockDates StructType
 * @subpackage Structs
 */
class InvBlockDates extends AbstractStructBase
{
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The EndDateExtensionIndicator
     * @var bool
     */
    public $EndDateExtensionIndicator;
    /**
     * The AbsoluteCutoff
     * @var string
     */
    public $AbsoluteCutoff;
    /**
     * The OffsetDuration
     * @var string
     */
    public $OffsetDuration;
    /**
     * The OffsetCalculationMode
     * @var string
     */
    public $OffsetCalculationMode;
    /**
     * Constructor method for InvBlockDates
     * @uses InvBlockDates::setStart()
     * @uses InvBlockDates::setDuration()
     * @uses InvBlockDates::setEnd()
     * @uses InvBlockDates::setEndDateExtensionIndicator()
     * @uses InvBlockDates::setAbsoluteCutoff()
     * @uses InvBlockDates::setOffsetDuration()
     * @uses InvBlockDates::setOffsetCalculationMode()
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param bool $endDateExtensionIndicator
     * @param string $absoluteCutoff
     * @param string $offsetDuration
     * @param string $offsetCalculationMode
     */
    public function __construct($start = null, $duration = null, $end = null, $endDateExtensionIndicator = null, $absoluteCutoff = null, $offsetDuration = null, $offsetCalculationMode = null)
    {
        $this
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setEndDateExtensionIndicator($endDateExtensionIndicator)
            ->setAbsoluteCutoff($absoluteCutoff)
            ->setOffsetDuration($offsetDuration)
            ->setOffsetCalculationMode($offsetCalculationMode);
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\InvBlockDates
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\InvBlockDates
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\InvBlockDates
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get EndDateExtensionIndicator value
     * @return bool|null
     */
    public function getEndDateExtensionIndicator()
    {
        return $this->EndDateExtensionIndicator;
    }
    /**
     * Set EndDateExtensionIndicator value
     * @param bool $endDateExtensionIndicator
     * @return \StructType\InvBlockDates
     */
    public function setEndDateExtensionIndicator($endDateExtensionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($endDateExtensionIndicator) && !is_bool($endDateExtensionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($endDateExtensionIndicator, true), gettype($endDateExtensionIndicator)), __LINE__);
        }
        $this->EndDateExtensionIndicator = $endDateExtensionIndicator;
        return $this;
    }
    /**
     * Get AbsoluteCutoff value
     * @return string|null
     */
    public function getAbsoluteCutoff()
    {
        return $this->AbsoluteCutoff;
    }
    /**
     * Set AbsoluteCutoff value
     * @param string $absoluteCutoff
     * @return \StructType\InvBlockDates
     */
    public function setAbsoluteCutoff($absoluteCutoff = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteCutoff) && !is_string($absoluteCutoff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteCutoff, true), gettype($absoluteCutoff)), __LINE__);
        }
        $this->AbsoluteCutoff = $absoluteCutoff;
        return $this;
    }
    /**
     * Get OffsetDuration value
     * @return string|null
     */
    public function getOffsetDuration()
    {
        return $this->OffsetDuration;
    }
    /**
     * Set OffsetDuration value
     * @param string $offsetDuration
     * @return \StructType\InvBlockDates
     */
    public function setOffsetDuration($offsetDuration = null)
    {
        // validation for constraint: string
        if (!is_null($offsetDuration) && !is_string($offsetDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetDuration, true), gettype($offsetDuration)), __LINE__);
        }
        $this->OffsetDuration = $offsetDuration;
        return $this;
    }
    /**
     * Get OffsetCalculationMode value
     * @return string|null
     */
    public function getOffsetCalculationMode()
    {
        return $this->OffsetCalculationMode;
    }
    /**
     * Set OffsetCalculationMode value
     * @param string $offsetCalculationMode
     * @return \StructType\InvBlockDates
     */
    public function setOffsetCalculationMode($offsetCalculationMode = null)
    {
        // validation for constraint: string
        if (!is_null($offsetCalculationMode) && !is_string($offsetCalculationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetCalculationMode, true), gettype($offsetCalculationMode)), __LINE__);
        }
        $this->OffsetCalculationMode = $offsetCalculationMode;
        return $this;
    }
}
