<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Shipment
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The SenderInformation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var SenderInformation
     */
    public $SenderInformation;
    /**
     * The ReceiverInformation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var ReceiverInformation
     */
    public $ReceiverInformation;
    /**
     * The PaymentInformation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var PaymentInformation
     */
    public $PaymentInformation;
    /**
     * The ShipmentDetails
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var EstimateInformation
     */
    public $ShipmentDetails;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setSenderInformation()
     * @uses Shipment::setReceiverInformation()
     * @uses Shipment::setPaymentInformation()
     * @uses Shipment::setShipmentDetails()
     * @param SenderInformation $senderInformation
     * @param ReceiverInformation $receiverInformation
     * @param PaymentInformation $paymentInformation
     * @param EstimateInformation $shipmentDetails
     */
    public function __construct(SenderInformation $senderInformation = null, ReceiverInformation $receiverInformation = null, PaymentInformation $paymentInformation = null, EstimateInformation $shipmentDetails = null)
    {
        $this
            ->setSenderInformation($senderInformation)
            ->setReceiverInformation($receiverInformation)
            ->setPaymentInformation($paymentInformation)
            ->setShipmentDetails($shipmentDetails);
    }
    /**
     * Get SenderInformation value
     * @return SenderInformation|null
     */
    public function getSenderInformation()
    {
        return $this->SenderInformation;
    }
    /**
     * Set SenderInformation value
     * @param SenderInformation $senderInformation
     * @return Shipment
     */
    public function setSenderInformation(SenderInformation $senderInformation = null)
    {
        $this->SenderInformation = $senderInformation;
        return $this;
    }
    /**
     * Get ReceiverInformation value
     * @return ReceiverInformation|null
     */
    public function getReceiverInformation()
    {
        return $this->ReceiverInformation;
    }
    /**
     * Set ReceiverInformation value
     * @param ReceiverInformation $receiverInformation
     * @return Shipment
     */
    public function setReceiverInformation(ReceiverInformation $receiverInformation = null)
    {
        $this->ReceiverInformation = $receiverInformation;
        return $this;
    }
    /**
     * Get PaymentInformation value
     * @return PaymentInformation|null
     */
    public function getPaymentInformation()
    {
        return $this->PaymentInformation;
    }
    /**
     * Set PaymentInformation value
     * @param PaymentInformation $paymentInformation
     * @return Shipment
     */
    public function setPaymentInformation(PaymentInformation $paymentInformation = null)
    {
        $this->PaymentInformation = $paymentInformation;
        return $this;
    }
    /**
     * Get ShipmentDetails value
     * @return EstimateInformation|null
     */
    public function getShipmentDetails()
    {
        return $this->ShipmentDetails;
    }
    /**
     * Set ShipmentDetails value
     * @param EstimateInformation $shipmentDetails
     * @return Shipment
     */
    public function setShipmentDetails(EstimateInformation $shipmentDetails = null)
    {
        $this->ShipmentDetails = $shipmentDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Shipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
