<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEstimateResponseContainer StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEstimateResponseContainer
 * @subpackage Structs
 */
class GetEstimateResponseContainer extends ResponseContainer
{
    /**
     * The TariffCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TariffCode;
    /**
     * The DiscountPoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DiscountPoint;
    /**
     * The TransitDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransitDays;
    /**
     * The EstimatedDeliveryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedDeliveryDate;
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalPrice;
    /**
     * The LineItemDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfLineItem
     */
    public $LineItemDetails;
    /**
     * The AccessorialDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfAccessorialItem
     */
    public $AccessorialDetails;
    /**
     * The ShipmentTaxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfTax
     */
    public $ShipmentTaxes;
    /**
     * Constructor method for GetEstimateResponseContainer
     * @uses GetEstimateResponseContainer::setTariffCode()
     * @uses GetEstimateResponseContainer::setDiscountPoint()
     * @uses GetEstimateResponseContainer::setTransitDays()
     * @uses GetEstimateResponseContainer::setEstimatedDeliveryDate()
     * @uses GetEstimateResponseContainer::setTotalPrice()
     * @uses GetEstimateResponseContainer::setLineItemDetails()
     * @uses GetEstimateResponseContainer::setAccessorialDetails()
     * @uses GetEstimateResponseContainer::setShipmentTaxes()
     * @param string $tariffCode
     * @param float $discountPoint
     * @param int $transitDays
     * @param string $estimatedDeliveryDate
     * @param float $totalPrice
     * @param ArrayOfLineItem $lineItemDetails
     * @param ArrayOfAccessorialItem $accessorialDetails
     * @param ArrayOfTax $shipmentTaxes
     */
    public function __construct($tariffCode = null, $discountPoint = null, $transitDays = null, $estimatedDeliveryDate = null, $totalPrice = null, ArrayOfLineItem $lineItemDetails = null, ArrayOfAccessorialItem $accessorialDetails = null, ArrayOfTax $shipmentTaxes = null)
    {
        $this
            ->setTariffCode($tariffCode)
            ->setDiscountPoint($discountPoint)
            ->setTransitDays($transitDays)
            ->setEstimatedDeliveryDate($estimatedDeliveryDate)
            ->setTotalPrice($totalPrice)
            ->setLineItemDetails($lineItemDetails)
            ->setAccessorialDetails($accessorialDetails)
            ->setShipmentTaxes($shipmentTaxes);
    }
    /**
     * Get TariffCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTariffCode()
    {
        return isset($this->TariffCode) ? $this->TariffCode : null;
    }
    /**
     * Set TariffCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tariffCode
     * @return GetEstimateResponseContainer
     */
    public function setTariffCode($tariffCode = null)
    {
        if (is_null($tariffCode) || (is_array($tariffCode) && empty($tariffCode))) {
            unset($this->TariffCode);
        } else {
            $this->TariffCode = $tariffCode;
        }
        return $this;
    }
    /**
     * Get DiscountPoint value
     * @return float|null
     */
    public function getDiscountPoint()
    {
        return $this->DiscountPoint;
    }
    /**
     * Set DiscountPoint value
     * @param float $discountPoint
     * @return GetEstimateResponseContainer
     */
    public function setDiscountPoint($discountPoint = null)
    {
        $this->DiscountPoint = $discountPoint;
        return $this;
    }
    /**
     * Get TransitDays value
     * @return int|null
     */
    public function getTransitDays()
    {
        return $this->TransitDays;
    }
    /**
     * Set TransitDays value
     * @param int $transitDays
     * @return GetEstimateResponseContainer
     */
    public function setTransitDays($transitDays = null)
    {
        $this->TransitDays = $transitDays;
        return $this;
    }
    /**
     * Get EstimatedDeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return isset($this->EstimatedDeliveryDate) ? $this->EstimatedDeliveryDate : null;
    }
    /**
     * Set EstimatedDeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedDeliveryDate
     * @return GetEstimateResponseContainer
     */
    public function setEstimatedDeliveryDate($estimatedDeliveryDate = null)
    {
        if (is_null($estimatedDeliveryDate) || (is_array($estimatedDeliveryDate) && empty($estimatedDeliveryDate))) {
            unset($this->EstimatedDeliveryDate);
        } else {
            $this->EstimatedDeliveryDate = $estimatedDeliveryDate;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return GetEstimateResponseContainer
     */
    public function setTotalPrice($totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get LineItemDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfLineItem|null
     */
    public function getLineItemDetails()
    {
        return isset($this->LineItemDetails) ? $this->LineItemDetails : null;
    }
    /**
     * Set LineItemDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfLineItem $lineItemDetails
     * @return GetEstimateResponseContainer
     */
    public function setLineItemDetails(ArrayOfLineItem $lineItemDetails = null)
    {
        if (is_null($lineItemDetails) || (is_array($lineItemDetails) && empty($lineItemDetails))) {
            unset($this->LineItemDetails);
        } else {
            $this->LineItemDetails = $lineItemDetails;
        }
        return $this;
    }
    /**
     * Get AccessorialDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfAccessorialItem|null
     */
    public function getAccessorialDetails()
    {
        return isset($this->AccessorialDetails) ? $this->AccessorialDetails : null;
    }
    /**
     * Set AccessorialDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfAccessorialItem $accessorialDetails
     * @return GetEstimateResponseContainer
     */
    public function setAccessorialDetails(ArrayOfAccessorialItem $accessorialDetails = null)
    {
        if (is_null($accessorialDetails) || (is_array($accessorialDetails) && empty($accessorialDetails))) {
            unset($this->AccessorialDetails);
        } else {
            $this->AccessorialDetails = $accessorialDetails;
        }
        return $this;
    }
    /**
     * Get ShipmentTaxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfTax|null
     */
    public function getShipmentTaxes()
    {
        return isset($this->ShipmentTaxes) ? $this->ShipmentTaxes : null;
    }
    /**
     * Set ShipmentTaxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfTax $shipmentTaxes
     * @return GetEstimateResponseContainer
     */
    public function setShipmentTaxes(ArrayOfTax $shipmentTaxes = null)
    {
        if (is_null($shipmentTaxes) || (is_array($shipmentTaxes) && empty($shipmentTaxes))) {
            unset($this->ShipmentTaxes);
        } else {
            $this->ShipmentTaxes = $shipmentTaxes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetEstimateResponseContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
